% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_trans_probs.R
\name{check_trans_prob_mat}
\alias{check_trans_prob_mat}
\title{Check Transition Probability Matrix}
\usage{
check_trans_prob_mat(
  m_P,
  dead_state = NULL,
  confirm_ok = FALSE,
  stop_if_not = FALSE
)
}
\arguments{
\item{m_P}{The transition probability matrix to be checked.}

\item{dead_state}{character vector length 1 denoting dead state (e.g. "D")}

\item{confirm_ok}{if OK, return a message confirming all checks passed.}

\item{stop_if_not}{return error messages. The default (FALSE) returns warnings.}
}
\value{
A message indicating whether the matrix passed all the checks or a warning/error message if any check failed.
}
\description{
This function checks the properties of a transition probability matrix conform to
standard expectations. That it is: square, numeric, values are between 0
and 1 with all rows summing to 1. If a dead state is provided, it checks that the dead
state -> dead state probability is 1.
}
\examples{
v_hs_names <- c("H", "S", "D")
n_hs <- length(v_hs_names)
m_P <- matrix(data = 0, nrow = n_hs, ncol = n_hs,
              dimnames = list(v_hs_names, v_hs_names))
m_P["H", "S"] <- 0.3
m_P["H", "D"] <- 0.01
m_P["S", "D"] <- 0.1
m_P["S", "H"] <- 0.5
diag(m_P) <- (1 - rowSums(m_P))
check_trans_prob_mat(m_P)

# introduce error
m_P["H", "S"] <- 0.2
try(check_trans_prob_mat(m_P,  confirm_ok = TRUE, stop_if_not = TRUE))

}
