#'Numbers of Diplostomum metacercariae recorded from the eyes (excluding lenses) 
#'of each of 50 ruffe.
#'
#'A dataset containing the numbers of Diplostomum metacercariae recovered from 
#'the eyes (excluding lenses) of each of 50 ruffe, Gymnocephalus cernuus from 
#'Llyn Tegid, a mesotrophic lake in north Wales. 
#'
#' @format A data frame with 50 rows and 2 variables (row names are host IDs):
#' \describe{
#'  \item{left}{number of metacercariae in left eye}
#'  \item{right}{number of metacercariae in the right eye}
#'  }
"diplostomum_eyes_excl_lenses"

#'Numbers of Diplostomum metacercariae recorded from the lenses of the eyes
#'of each of 50 ruffe.
#'
#'A dataset containing the numbers of Diplostomum metacercariae recovered from 
#'the lenses of the eyes of each of 50 ruffe, Gymnocephalus cernuus from
#'Llyn Tegid, a mesotrophic lake in north Wales.
#'
#' @format A data frame with 50 rows and 2 variables (row names are host IDs):
#' \describe{
#'  \item{left}{number of metacercariae in lens of left eye}
#'  \item{right}{number of metacercariae in lens of right eye}
#'  }
"diplostomum_lenses"

#'Simulated data showing bilateral asymmetry with insconsistent bias
#'
#'Simulated data for 10 hosts, providing an example of bilateral asymmetry with inconsistent bias.
#'
#' @format A data frame with 10 rows and 2 variables:
#' \describe{
#'  \item{left}{number of parasites on the left side}
#'  \item{right}{number of parasites on the right side}
#'  }
"simulated_asymmetry_inconsistent_bias"

#'Simulated data showing bilateral symmetry
#'
#'Simulated data for 10 hosts, providing an example of bilateral symmetry. 
#'
#'@format A data frame with 10 rows and 2 variables:
#'\describe{
#'  \item{left}{number of parasites on the left side}
#'  \item{right}{number of parasites on the right side}
#'  }
"simulated_symmetrical_infection"

#'Simulated data showing left bias with heterogeneous proportions
#'
#'Simulated data for 10 hosts, providing an example of bilateral asymmetry with left bias
#'and the left:right ratio varying between hosts. 
#'
#'@format A data frame with 10 rows and 2 variables:
#'\describe{
#'  \item{left}{number of parasites on the left side}
#'  \item{right}{number of parasites on the right side}
#'  }
"simulated_left_bias_heterogeneous_proportions"

#'Simulated data for showing left bias with homogeneous proportions
#'
#'Simulated data for 10 hosts, providing an example of bilateral asymmetry with left bias
#'and a similar left:right ratio in all hosts. 
#'
#'@format A data frame with 10 rows and 2 variables:
#'\describe{
#'  \item{left}{number of parasites on the left side}
#'  \item{right}{number of parasites on the right side}
#'  }
"simulated_left_bias_homogeneous_proportions"
