% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{arrow_head_bezier}
\alias{arrow_head_bezier}
\title{make arrowhead from list of bezier control points}
\usage{
arrow_head_bezier(
  x,
  rotate = 0,
  rescale = c(1, 1),
  nudge = c(0, 0),
  transformations = c("rotater", "rescaler", "nudger"),
  n = 101,
  plot = FALSE,
  show_controls = TRUE
)
}
\arguments{
\item{x}{list of control points (as vectors or matrices)}

\item{rotate}{rotation angle in radians}

\item{rescale}{a single value or 2-length vector for scaling in x and y}

\item{nudge}{a single value or 2-length vector for nudging in x and y}

\item{transformations}{a vector of transformation functions}

\item{n}{number of points in each bezier curve}

\item{plot}{plot arrowhead if TRUE}

\item{show_controls}{show control points if plot = TRUE}
}
\value{
a matrix
}
\description{
make arrowhead from list of bezier control points
}
\examples{
curved_arrowhead <- arrow_head_bezier(list(
  c(1,  0,
    .5, .5,
    .2, .5),
  c(.2, .5,
    .2, .1,
    -.1, .25,
    -.3, .25),
  c(-.3, .25,
    0, 0,
    -.3, -.25),
  c(-.3, -.25,
    -.1, -.25,
    .2,  -.1,
    .2, -.5),
  c(.2, -.5,
    .5, -.5,
    1,  0)
),
plot = TRUE)
}
