% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arlc_clean_final_rules.R
\name{arlc_clean_final_rules}
\alias{arlc_clean_final_rules}
\title{Clean Final Rules}
\usage{
arlc_clean_final_rules(final_rules)
}
\arguments{
\item{final_rules}{A set of final rules to be cleaned.}
}
\value{
A cleaned set of rules.
}
\description{
This function cleans the final set of association rules.
}
\examples{
\donttest{
library(arlclustering)
# Create a sample transactions dataset
sample_gml_file <- system.file("extdata", "karate.gml", package = "arlclustering")
g <- arlc_get_network_dataset(sample_gml_file, "Karate Club")
trans <- arlc_gen_transactions(g$graph)
supportRange <- seq(0.1, 0.2, by = 0.1)
Conf <- 0.5
params <- arlc_get_apriori_thresholds(trans, supportRange, Conf)
grossRules <- arlc_gen_gross_rules(trans, params$minSupp, params$minConf, 1, params$lenRules)
nonRR_rules <- arlc_get_NonR_rules(grossRules$GrossRules)
NonRRSig_rules <- arlc_get_significant_rules(trans, nonRR_rules$FiltredRules)
cleaned_rules <- arlc_clean_final_rules(NonRRSig_rules$FiltredRules)
message(cleaned_rules)
}
}
