% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_OCR_document.R
\name{OCR_document}
\alias{OCR_document}
\title{Scan PDF with optical character recognition (OCR)}
\usage{
OCR_document(in_path, out_path, method = "nougat", verbose = TRUE)
}
\arguments{
\item{in_path}{character. string of a file with species data in either pdf or txt format, e.g: ./folder/file.pdf}

\item{out_path}{character. Binomial name of the species used with applicable \code{type}.}

\item{method}{character. Method used for the OCR. Currently it defaults to the only available method, nougatOCR.}

\item{verbose}{logical. Print output after finish.}
}
\value{
character. Containing the extracted information.
}
\description{
Extract text contained under image form in a PDF through the use
of optical character recognition software (OCR). Currently two options are
available, \code{method = "nougat"} and \code{method = "tesseract"}.
}
\details{
For now OCR processing of documents is only supported on linux
systems.
}
\examples{
\dontrun{
OCR_document("path/to/file.pdf", "path/to/dir")
}
}
\seealso{
\code{\link{arete_setup}}
}
