% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/live.R
\name{run_server}
\alias{run_server}
\title{Run server providing data for live Arena}
\usage{
run_server(
  arena,
  port = 8181,
  host = "127.0.0.1",
  open_browser = TRUE,
  append_data = FALSE,
  arena_url = "https://arena.drwhy.ai/"
)
}
\arguments{
\item{arena}{Live arena object}

\item{port}{server port}

\item{host}{server ip address (hostnames do not work yet)}

\item{open_browser}{Whether to open browser with new session}

\item{append_data}{Whether to append data to already existing session}

\item{arena_url}{URL of Arena dashboard instance}
}
\value{
not modified arena object
}
\description{
By default function opens browser with new arena session. Appending data to
already existing session is also possible using argument \code{append_data}
}
\examples{
library("DALEX")
library("arenar")
library("dplyr", quietly=TRUE, warn.conflicts = FALSE)
# create a model
model <- glm(m2.price ~ ., data=apartments)
# create a DALEX explainer
explainer <- DALEX::explain(model, data=apartments, y=apartments$m2.price)
# generate live arena for one model and all data as observations
arena <- create_arena(live=TRUE) \%>\% push_model(explainer) \%>\% push_observations(apartments)
# run the server
if (interactive()) run_server(arena, port=1234)
}
