% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/areabiplot.R
\name{areabiplot}
\alias{areabiplot}
\title{Area Biplot}
\usage{
areabiplot(
  L,
  S,
  R,
  ord.row,
  mode = NULL,
  tri.rgb = NULL,
  bg.col = NULL,
  plot.title = NULL,
  plot.title.col = NULL,
  plot.title.font = NULL,
  plot.title.cex = NULL,
  plot.sub = NULL,
  plot.sub.col = NULL,
  plot.sub.font = NULL,
  plot.sub.cex = NULL,
  plot.cex = NULL,
  plot.col = NULL,
  plot.pch = NULL,
  plot.xlab = NULL,
  plot.ylab = NULL,
  plot.xlim = NULL,
  plot.ylim = NULL,
  points.lab = NULL,
  var.lab = NULL,
  text.col.var = NULL,
  text.cex = NULL,
  text.font = NULL,
  text.col = NULL,
  text.pos = NULL,
  axis.col = NULL,
  axis.cex = NULL,
  axis.font = NULL,
  axis.asp = NULL,
  arrow.lwd = NULL,
  arrow.len = NULL,
  arrow.col = NULL
)
}
\arguments{
\item{L}{A (n x 2) matrix containing normalized score vectors \eqn{g} (or left singular
vectors \eqn{u}).}

\item{S}{An appropriate (2 x 2) diagonal matrix containing the corresponding singular
values in decreasing order.}

\item{R}{A (m x 2) matrix containing the corresponding loading vectors (or right singular
vectors).}

\item{ord.row}{The row  of \eqn{R} used as the base of the triangle, e.g.,
if 1 is provided, then the first row of \eqn{R} will be taken.}

\item{mode}{a string providing the way the singular values will be allocated. The default
is "SS", i.e., the similar spread proposed by Gower et al.. Alternatively,
one can choose the "HJ" method (see more in Details).}

\item{tri.rgb}{The hexadecimal color and alpha transparency code for the triangle. The
default is #19FF811A (green and 90\% of transparency).}

\item{bg.col}{A string providing the color of the background. The default is #001F3D (blue).}

\item{plot.title}{A string providing the main title. The default is NONE.}

\item{plot.title.col}{A string specifying the color of the main title text. The default is "FFFFFF"
(white).}

\item{plot.title.font}{An integer providing the style of the main title text. The default is 1 (normal
text).}

\item{plot.title.cex}{A number indicating the amount by which the main title text should be scaled
relative to the default. 1 = default, 1.5 is 50\% larger, and so on.}

\item{plot.sub}{A string providing a sub-title. The default is NONE.}

\item{plot.sub.col}{A string specifying the color of the sub-title text. The default is "FFFFFF"
(white).}

\item{plot.sub.font}{An integer providing the style of the main title text. The default is 1 (normal
text).}

\item{plot.sub.cex}{A number indicating the amount by which the sun-title text should be scaled
relative to the default. 1 = default, 1.5 is 50\% larger, and so on.}

\item{plot.cex}{A number indicating the expansion or contraction factor used to specify the
point size. The default is 0.6 (40\% smaller).}

\item{plot.col}{A string specifying the color of the points. The default is "FFFFFF" (white).}

\item{plot.pch}{An integer specifying the shape of the points. The default is 21 (circle)}

\item{plot.xlab}{A string specifying a label to the horizontal axis. The default is NONE.}

\item{plot.ylab}{A string specifying a label to the vertical axis. The default is NONE.}

\item{plot.xlim}{The limits for the x axis.}

\item{plot.ylim}{The limits for the y axis.}

\item{points.lab}{A vector of characters containing the names of the data matrix rows.}

\item{var.lab}{A string providing the variable name used as triangle base.}

\item{text.col.var}{A string specifying the color of the variable label text. The default is
"FFFFFF" (white).}

\item{text.cex}{A number indicating the expansion or contraction factor used to specify
the point labels. The default is 0.5.}

\item{text.font}{An integer providing the style of the point labels. The default is 2 (bold).}

\item{text.col}{A string specifying the color of the point labels text. The default is
"FFFFFF" (white).}

\item{text.pos}{An integer providing the position of the point labels. The default is 3
(above).}

\item{axis.col}{A string specifying the color of the axis. The default is #FFFFFF (white).}

\item{axis.cex}{A number indicating the expansion or contraction factor used to specify
the tick label. The default is 0.7}

\item{axis.font}{An integer providing the style of the tick label. The default is 1 (normal
text).}

\item{axis.asp}{A number specifying the aspect ratio of the axes. The default is 1.}

\item{arrow.lwd}{A number specifying the line width of the arrow. The default is 1.}

\item{arrow.len}{The length of the edges of the arrow head (in inches). The default is 0.1.}

\item{arrow.col}{A string specifying the color of the arrow. The default is "FFFFFF"
(white).}
}
\value{
An area biplot is produced on the current graphics device.
}
\description{
Consider an (n x m) centered data matrix \eqn{X} and let \eqn{rank(X) = r}.
Alternatively to the ordinary NIPALS decomposition of \eqn{X}, where \eqn{X = T P'},
this package uses the resulting matrices from the extended version of the NIPALS
decomposition (\eqn{X = G H P'}) to determine \eqn{n} triangles whose areas are
used to visually estimate the \eqn{n} elements of a specific column of \eqn{X}
(a variable of interest). After a 90-degree rotation of the sample points, the
triangles are drawn regarding the following points:
\enumerate{
\item the origin of the axes.
\item the sample points.
\item the vector endpoint representing the selected variable.
}

Just keep in mind that The extended NIPALS decomposition, \eqn{X = G H P'}, is
equivalent to the SVD decomposition, \eqn{X = U D V'}, being that:
\enumerate{
\item \eqn{G} is the matrix containing in its columns the normalized score vectors
of \eqn{X}, i.e., the normalized columns of \eqn{T}. If \eqn{t} is the i-th score
vector of the matrix \eqn{T}, then the i-th column of  \eqn{G} will be
\eqn{g = t / || t || }, which will correspond to the i-th left singular vector \eqn{u}.
\item If \eqn{t} is the i-th column of \eqn{T}, then \eqn{|| t || = \sqrt(t' t)} gives
the i-th singular value of \eqn{X}. In addition, \eqn{H} is the diagonal matrix
containing these singular values in decreasing order, i.e., \eqn{H = D}.
\item \eqn{P} is the loadings matrix, which is equivalent to the \eqn{V} matrix that
contains the right singular vectors of \eqn{X}.
}
}
\details{
\enumerate{
\item If the variables (the columns of X) are measured in different units or
their variability differs considerably, one could perform a variance scaling
to get better visual results on the graph (see Examples). In this case, the
percentage of variance explained by the first principal components might decrease.
\item The "HJ" mode is reserved for an application under implementation.
}
}
\examples{
library(nipals)
data(uscrime)
Y = uscrime[, -1]

# first case: scale is false
nip = nipals(Y, ncomp = 2, center = TRUE, scale = FALSE, force.na = TRUE)
L = nip$scores
R = nip$loadings
S = diag(nip$eig[1:2])
areabiplot(L, S, R, 5, points.lab = c(uscrime[, 1]),var.lab= "burglary")

# second case: scale is true
nip = nipals(Y, ncomp = 2, center = TRUE, scale = TRUE, force.na = TRUE)
L = nip$scores
R = nip$loadings
S = diag(nip$eig[1:2])
areabiplot(L, S, R, 4, points.lab = c(uscrime[, 1]),var.lab= "assault")


}
\references{
J.C. Gower, P.J.F. Groenen, M. van de Velden (2010). Area Biplots. Journal of Computational and
Graphical Statistics, v.19 (1), pp. 46-61. \doi{10.1198/jcgs.2010.07134}
}
\author{
Alberto Silva \href{mailto:albertos@ua.pt}{albertos@ua.pt}, Adelaide Freitas \href{mailto:adelaide@ua.pt}{adelaide@ua.pt}
}
