% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arakno.R
\name{endemics}
\alias{endemics}
\title{Get country endemics from WSC.}
\usage{
endemics(country)
}
\arguments{
\item{country}{The ISO3 code (preferred to avoid ambiguity) or country/region name.}
}
\value{
A vector with species names.
}
\description{
Get endemic species in any country or region from the World Spider Catalogue textual descriptions.
}
\details{
Species list based on the interpretation of the textual descriptions available at the World Spider Catalogue (2025). These might be only approximations to country level and should be taken with caution.
}
\examples{
\dontrun{
endemics("PRT")
endemics("Madeira")
endemics("Finland")
}
}
\references{
World Spider Catalog (2025). World Spider Catalog. Version 26. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
