% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ash_properties.R
\name{ash_properties}
\alias{ash_properties}
\title{Build the properties of an Appsheet request}
\usage{
ash_properties(
  Locale = "en-US",
  Location = NULL,
  RunAsUserEmail = NULL,
  Timezone = NULL,
  UserSettings = NULL,
  Selector = NULL,
  ...
)
}
\arguments{
\item{Locale}{Locale of the client making the request.
For example, en-US indicates English, United States.
If this value is not specified, Locale defaults to en-US. \cr
The Locale is used when validating Date, DateTime, Decimal, Percent, Price, and Time data values.
For example, when Locale is en-US, date values must be entered in MM/DD/YYYY format;
when Locale is en-GB, date values must be entered in DD/MM/YYYY format.}

\item{Location}{Latitude and longitude of the client making the request.
If not specified, Location defaults to 0.000000, 0.000000.}

\item{RunAsUserEmail}{User email address of the person taking the action.
The action is performed under the user email address you specify.
If this value is not specified, the action is performed under the user email address
of the application owner.}

\item{Timezone}{Timezone of the client making the request.}

\item{UserSettings}{User setting to be used when performing the action.
If not specified, no user settings are used.}

\item{Selector}{Expression to select and format the rows returned.
Only valid when Action is "Find".}

\item{...}{Placeholder for future properties to be introduced in the API.}
}
\value{
A list of properties
}
\description{
This function exist to provide auto completion. Still, it is
likely that users will need to visit the \href{https://support.google.com/appsheet/answer/10105398}{official documentation}
for further customization.
}
\details{
Any NULL will be internally dropped before performing the request.
}
\examples{
ash_properties()
ash_properties(Locale = "en-GB")
}
