% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_define.R
\name{pk_define}
\alias{pk_define}
\title{Create definition file from published dataset}
\usage{
pk_define(
  df,
  file = NULL,
  project,
  data,
  variable.list,
  template = NULL,
  font = "Times New Roman",
  size = 9,
  na = -999
)
}
\arguments{
\item{df}{apmx analysis dataset}

\item{file}{optional filepath for defintion file (.docx file)}

\item{project}{project name}

\item{data}{dataset name}

\item{variable.list}{reference dataframe for variable definitions}

\item{template}{optional filepath for definition file template (.docx file)}

\item{font}{font for table contents}

\item{size}{font size for table contents}

\item{na}{value used for missing or na numeric covariates}
}
\value{
dataset definition file
}
\description{
Definition file table can be read into a template word document (.docx) or blank document if desired.
Definitions are sourced from a variable list stored separately on your server.
Please refer to apmx::variable_list_export() for a standard copy of the variable list.
}
\examples{
## Simple ex domain with 1 subject and 1 dose
ex <- data.frame(STUDYID = "ABC101",
                 USUBJID = "ABC101-001",
                 EXSTDTC = "2000-01-01 10:00:00",
                 EXSTDY = 1,
                 EXTPTNUM = 0,
                 EXDOSE = 100,
                 CMT = 1,
                 EXTRT = "ABC",
                 EXDOSU = "mg",
                 VISIT = "Day 1",
                 EXTPT = "Dose",
                 EXDOSFRQ = "Once",
                 EXROUTE = "Oral")

## Simple pc domain with 1 subject and 3 observations
pc <- data.frame(USUBJID = "ABC101-001",
                 PCDTC = c("2000-01-01 09:40:00",
                           "2000-01-01 10:29:00",
                           "2000-01-01 12:05:00"),
                 PCDY = 1,
                 PCTPTNUM = c(0, ##Units of hours
                              0.021,
                              0.083),
                 PCSTRESN = c(NA,
                              469,
                              870),
                 PCLLOQ = 25,
                 CMT = 2,
                 VISIT = "Day 1",
                 PCTPT = c("Pre-dose",
                           "30-min post-dose",
                           "2-hr post-dose"),
                 PCTEST = "ABC",
                 PCSTRESU = "ug/mL")

## Create apmx dataset with pk_build()
df <- pk_build(ex, pc)

## Create variable definitions with variable_list_create()
vl <- variable_list_create()

## Create definition file
pk_define(df, variable.list = vl)

}
