% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_stats.R
\name{outlier_stats}
\alias{outlier_stats}
\title{Outlier statistics}
\usage{
outlier_stats(model, n = 6L)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{n}{an integer vector of length up to \code{dim(x)} (or 1,
    for non-dimensioned objects). Values specify the indices to be
    selected in the corresponding dimension (or along the length) of the
    object. A positive value of \code{n[i]} includes the first/last
    \code{n[i]} indices in that dimension, while a negative value
    excludes the last/first \code{abs(n[i])}, including all remaining
    indices. \code{NA} or non-specified values (when \code{length(n) <
      length(dim(x))}) select all indices in that dimension. Must
    contain at least one non-missing value.}
}
\value{
A vector of statistics.
}
\description{
\code{outlier_stats} returns the ordered
studentized residuals (decreasing based on magnitude) of
\code{model} to
Identify the most unusual observations.
}
\examples{
lmod <- lm(price ~ sqft_living, data = home_sales)
outlier_stats(lmod, n = 3)
}
