% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_plot.R
\name{outlier_plot}
\alias{outlier_plot}
\title{Index plot of studentized residuals for \code{lm} object}
\usage{
outlier_plot(
  model,
  id_n = 3,
  add_reference = TRUE,
  alpha = 0.05,
  ...,
  text_arglist = list(),
  abline_arglist = list(),
  extendrange_f = 0.08
)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{id_n}{The number of points to identify with labels.
The default is \code{3}.}

\item{add_reference}{A logical value indicating whether a
reference line should be added. The default is
\code{TRUE}. See Details.}

\item{alpha}{The default lower quantile used for the
reference line prior to the Bonferroni adjustment. The
default is 0.05.}

\item{...}{Additional arguments passed to the
\code{\link[graphics]{plot}} function.}

\item{text_arglist}{Additional arguments passed to the
\code{\link[graphics]{text}} function, which is used to
display the points that are identified.}

\item{abline_arglist}{A named list specifying additional
arguments passed to the \code{\link[graphics]{abline}}
function for the horizontal reference line added to the
plot.}

\item{extendrange_f}{Positive number(s) specifying the
fraction by which the range of the residuals should be
extended using the \code{\link[grDevices]{extendrange}}
function. If longer than one, \code{f[1]} is used on
the left and \code{f[2]} on the right.}
}
\description{
\code{outlier_plot} plots the studentized residuals (from
the \code{\link[stats]{rstudent}} function) of a fitted
\code{lm} object.
}
\details{
If \code{add_reference = TRUE}, then reference lines are
provided for the \eqn{\alpha/(2n} and \eqn{1-\alpha/(2n)}
quantiles of a Student's \eqn{t} distribution with
(\code{df.residual(lmod) - 1}) degrees of freedom, which
are the standard quantiles used to identify outliers for
a fitted model.

The vertical position of the reference line can be
customized by setting the \code{h} argument of
\code{abline_arglist}.
}
\examples{
lmod <- lm(price ~ sqft_living, data = home_sales)
outlier_plot(lmod, id_n = 1)
}
\seealso{
\code{\link[graphics]{plot}},
  \code{\link[graphics]{text}},
  \code{\link[graphics]{abline}},
  \code{\link[stats]{rstudent}}
}
\author{
Joshua French
}
