% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_aos.R
\name{use_aos}
\alias{use_aos}
\title{Use aos}
\usage{
use_aos(
  disable = FALSE,
  startEvent = "DOMContentLoaded",
  initClassName = "aos-init",
  animatedClassName = "aos-animate",
  useClassNames = FALSE,
  disableMutationObserver = FALSE,
  debounceDelay = "50",
  throttleDelay = "99",
  offset = "120",
  duration = "400",
  easing = "ease",
  delay = "0"
)
}
\arguments{
\item{disable}{string. Condition when AOS should be disabled, for example 'mobile'}

\item{startEvent}{string. Name of the event dispatched on the document, that AOS should initialize on}

\item{initClassName}{string. Class applied after initialization}

\item{animatedClassName}{string. Class applied on animation}

\item{useClassNames}{boolean. If true, will add content of data-aos as classes on scroll}

\item{disableMutationObserver}{boolean. Disables automatic mutations detections (advanced)}

\item{debounceDelay}{string. The delay on debounce used while resizing window (advanced)}

\item{throttleDelay}{string. The delay on throttle used while scrolling the page (advanced)}

\item{offset}{string. Change offset to trigger animations sooner or later, in px}

\item{duration}{string. Duration of animation in ms.}

\item{easing}{string. Timing function to animate elements nicely}

\item{delay}{string. Delay animation (ms)}
}
\value{
Javascript code initializing aos with dependencies.
}
\description{
Use aos
}
\examples{
if (interactive()) {
 library(shiny)
  shinyApp(
   ui = fluidPage(
     use_aos(), # add use_aos() in the UI
     aos(h1("Shiny with AOS - Animate On Scroll"), animation = "fade-zoom-in"),
     aos(textOutput("text"), animation = "fade-up")
   ),
  server <- function(input, output, session){
    output$text <- renderText({ print("An animated text.") })
  }
 )
}

}
