% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aos.R
\name{aos}
\alias{aos}
\title{Animate element on scroll}
\usage{
aos(
  element,
  animation,
  offset = "120",
  duration = "400",
  easing = "ease",
  delay = "0",
  anchor = "",
  anchor_placement = "top-bottom",
  once = FALSE,
  ...
)
}
\arguments{
\item{element}{An shiny or rmarkdown element.}

\item{animation}{An animation from \href{https://github.com/michalsnik/aos/tree/v2#-animations}{AOS}}

\item{offset}{string. Change offset to trigger animations sooner or later, px}

\item{duration}{string. Duration of animation in ms}

\item{easing}{string. Choose timing function to ease elements in different ways}

\item{delay}{string. Delay animation in ms}

\item{anchor}{string. Anchor placement}

\item{anchor_placement}{string. Anchor placement - which one position of element on the screen should trigger animation}

\item{once}{boolean.}

\item{...}{Additional class element}
}
\value{
Javascript code animating the element.
}
\description{
Animate on scroll a Shiny or R Markdown element.
}
\examples{
if (interactive()) {
 library(shiny)
  shinyApp(
   ui = fluidPage(
     use_aos(), # add use_aos() in the UI
     aos(h1("Shiny with AOS - Animate On Scroll"), animation = "fade-zoom-in"),
     aos(textOutput("text"), animation = "fade-up")
   ),
  server <- function(input, output, session){
    output$text <- renderText({ print("An animated text.") })
  }
 )
}

}
