% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nll_functions.R
\name{nll_frailty_shared}
\alias{nll_frailty_shared}
\title{Negative log-likelihood function: frailty shared}
\usage{
nll_frailty_shared(
  a1 = a1,
  b1 = b1,
  a2 = a2,
  b2 = b2,
  theta = theta,
  data = data,
  time = time,
  censor = censor,
  infected_treatment = infected_treatment,
  d1 = "",
  d2 = ""
)
}
\arguments{
\item{a1, b1}{location and scale parameters for background mortality}

\item{a2, b2}{location and scale parameters for mortality due to infection}

\item{theta}{parameter describing variance of unobserved variation acting on
mortality rates}

\item{data}{name of data frame containing survival data}

\item{time}{name of data frame column identifying time of event; time > 0}

\item{censor}{name of data frame column idenifying if event was death (0) or
right-censoring (1)}

\item{infected_treatment}{name of data frame column identifying if data are
from an infected (1) or uninfected (0) treatment}

\item{d1, d2}{names of probability distributions chosen to describe background
mortality and mortality due to infection, respectively; both default to the
Weibull distribution}
}
\value{
numeric
}
\description{
Function calculating negative log-likelihood (nll) for patterns of mortality
in infected and uninfected treatments where unobserved variation is assumed
to act equally on background mortality and mortality due to infection.
}
\details{
This function assumes unobserved variation acting on both the background rate
of mortality and the rate of mortality due to infection is continuously
distributed and follows the gamma distribution, with mean = 1.0 and variance
= theta. The function returns the nll based on five parameters; the location
and scale parameters for background mortality and mortality due to infection,
plus the parameter describing the variance of the unobserved variation.
}
\examples{

# step #1: prepare nll function for analysis
  m01_prep_function <- function(a1 = a1, b1 = b1, a2 = a2, b2 = b2, theta = theta){
    nll_frailty_shared(a1 = a1, b1 = b1, a2 = a2, b2 = b2, theta = theta,
      data = data_lorenz,
      time = t,
      censor = censored,
      infected_treatment = g,
      d1 = "Gumbel", d2 = "Gumbel"
      )}

# step #2: send 'prep_function' to mle2 for maximum likelihood estimation,
  # specifying starting values
  m01 <- mle2(m01_prep_function,
            start = list(a1 = 23, b1 = 5, a2 = 10, b2 = 1, theta = 1),
            method = "Nelder-Mead",
            control = list(maxit = 5000)
            )

  summary(m01)

}
\seealso{
\code{\link{nll_frailty}}
}
