% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nll_functions.R
\name{nll_exposed_infected}
\alias{nll_exposed_infected}
\title{Negative log-likelihood function: exposed-infected}
\usage{
nll_exposed_infected(
  a1 = a1,
  b1 = b1,
  a2 = a2,
  b2 = b2,
  p1 = p1,
  data = data,
  time = time,
  censor = censor,
  infected_treatment = infected_treatment,
  d1 = "Weibull",
  d2 = "Weibull"
)
}
\arguments{
\item{a1, b1}{location and scale parameters for background mortality}

\item{a2, b2}{location and scale parameters for mortality due to infection}

\item{p1}{unobserved proportion of hosts exposed to infection and infected; 0
<= p1 <= 1}

\item{data}{name of data frame containing survival data}

\item{time}{name of data frame column identifying time of event; time > 0}

\item{censor}{name of data frame column idenifying if event was death (0) or
right-censoring (1)}

\item{infected_treatment}{name of data frame column identifying if data are
from an infected (1) or uninfected (0) treatment}

\item{d1, d2}{names of probability distributions chosen to describe background
mortality and mortality due to infection, respectively'; both default to
the Weibull distribution}
}
\value{
numeric
}
\description{
Function returning negative log-likelihood (nll) for patterns of mortality in
infected and control treatments, where the infected population harbours an
unobserved proportion of hosts that were exposed to infection, but did not
become infected.
}
\details{
This function returns the nll based on five parameters, the location and
scale parameters for background mortality and mortality due to infection,
respectively, plus a parameter for the proportion of hosts that became
infected when exposed to infection.
}
\examples{
# check column names in head of data frame with data to analyse
    head(data_parker)

# step #1: prepare nll function for analysis
    m01_prep_function <- function(a1 = a1, b1 = b1, a2 = a2, b2 = b2, p1 = p1){
      nll_exposed_infected(
        a1 = a1, b1 = b1, a2 = a2, b2 = b2, p1 = p1,
        data = data_parker,
        time = t,
        censor = censored,
        infected_treatment = g,
        d1 = "Frechet",
        d2 = "Weibull")
        }

# step #2: send 'prep_function' to mle2 for maximum likelihood estimation
    m01 <- mle2(m01_prep_function,
             start = list(a1 = 2.5, b1 = 1, a2 = 2, b2 = 0.5, p1 = 0.5)
             )

    summary(m01)

# model setting lower & upper bounds to parameter estimates
  # including 0 < p1 < 1
    m02 <- mle2(m01_prep_function,
             start = list(a1 = 2.5, b1 = 1.2, a2 = 1.9, b2 = 0.16, p1 = 0.48),
             method = "L-BFGS-B",
             lower = c(a1 = 0, b1 = 0, a2 = 0, b2 = 0, p1 = 0),
             upper = c(a1 = Inf, b1 = Inf, a2 = Inf, b2 = Inf, p1 = 1),
             )

    summary(m02)


}
\seealso{
\code{\link{nll_two_inf_subpops_obs}}
  \code{\link{nll_two_inf_subpops_unobs}}
}
