% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.eq.2group.R
\name{power.eq.2group}
\alias{power.eq.2group}
\title{Statistical Power Analysis for Equivalence Tests of Two-Group Means}
\usage{
power.eq.2group(
  cost.model = FALSE,
  expr = NULL,
  constraint = NULL,
  d = NULL,
  eq.dis = NULL,
  m = NULL,
  c1 = NULL,
  c1t = NULL,
  n = NULL,
  p = NULL,
  q = 1,
  sig.level = 0.05,
  r12 = NULL,
  power = NULL,
  powerlim = NULL,
  nlim = NULL,
  mlim = NULL,
  eq.dislim = NULL,
  verbose = TRUE
)
}
\arguments{
\item{cost.model}{Logical; power analyses accommodating costs and budget
(e.g., required budget for desired power, power, minimum detectable
eq.dis under a fixed budget)
if TRUE. Otherwise, conventional power analysis is performed
(e.g., required sample size, power, or minimum detectable
eq.dis calculation);
default value is FALSE, and it will be changed to TRUE if
expr is not NULL.}

\item{expr}{Returned object from function
\code{\link{od.eq.2group}}; default value is NULL;
if \code{expr} is specified, parameter values of \code{r12},
\code{c1}, \code{c1t}, and \code{p}
used or solved in function \code{\link{od.eq.2group}} will
be passed to the current function;
only the value of \code{p} that specified or solved in
function \code{\link{od.eq.2group}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{Specify the constrained value of
\code{p} in list format to overwrite that
from \code{expr}; default value is NULL.}

\item{d}{The estimated difference in two-group means.}

\item{eq.dis}{A positive number to specify the distance from equivalence
bounds to \code{d}. The equivalence bounds are
c(-abs(d)-eq.dis, abs(d)+eq.dis).}

\item{m}{Total budget.}

\item{c1}{The cost of sampling one unit in the control condition.}

\item{c1t}{The cost of sampling one unit in the treated condition.}

\item{n}{The total sample size across groups.}

\item{p}{The proportion of individuals in the intervention group or group 1.}

\item{q}{The number of predictors in the combined linear regression model.
Default is 1.}

\item{sig.level}{The significance level. Default is .05.}

\item{r12}{The proportion of variance explained by covariates if any.}

\item{power}{Statistical power.}

\item{powerlim}{The range for solving the root of power (power) numerically,
default value is c(1e-10, 1 - 1e-10).}

\item{nlim}{The range for searching the root of sample size (n) numerically,
default value is c(4, 10e10).}

\item{mlim}{The range for searching the root of budget (\code{m}) numerically,
default value is the costs sampling \code{nlim}
units across treatment conditions or
c(4 * ncost, 10e10 * ncost) with ncost = ((1 - p) * c1 + p * c1t).}

\item{eq.dislim}{The range for solving the root of equivalence difference
with the effect size (d) numerically, default value is c(0, 10).}

\item{verbose}{Logical; print the process if TRUE,
otherwise not; default value is TRUE.}
}
\value{
Required budget (and/or required sample size), statistical power, or
    minimum detectable eq.dis
    depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
Statistical power analysis for equivalence test of
    two-group means.
}
\examples{
   library(anomo)
# 1. Conventional Power Analyses from Difference Perspectives
# Calculate the required sample size to achieve certain level of power
mysample <- power.eq.2group(d = .1, eq.dis = 0.1,  p =.5,
                            r12 = .5, q = 1, power = .8)
mysample$out

# Calculate power provided by a sample size allocation
mypower <- power.eq.2group(d = 1, eq.dis = .1, n = 1238, p =.5,
                           r12 = .5, q = 1)
mypower$out

# Calculate the minimum detectable distance a given sample size allocation
# can achieve
myeq.dis <- power.eq.2group(d = .1, n = 1238, p =.5,
                           r12 = .5, q = 1, power = .8)
myeq.dis$out

# 2. Power Analyses Using Optimal Sample Allocation
myod <- od.eq.2group(r12 = 0.5, c1 = 1, c1t = 10)
budget <- power.eq.2group(expr = myod, d = .1, eq.dis = 0.1,
                          q = 1, power = .8)
budget.balanced <- power.eq.2group(expr = myod, d = .1, eq.dis = 0.1,
                                   q = 1, power = .8,
                                   constraint = list(p = .50))
(budget.balanced$out$m-budget$out$m)/budget$out$m *100
# 27\% more budget required from the balanced design with p = 0.50.

}
