% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.eq.2group.R
\name{od.eq.2group}
\alias{od.eq.2group}
\title{Optimal sample allocation calculation for equivalence test of two-group
means}
\usage{
od.eq.2group(
  p = NULL,
  r12 = NULL,
  c1 = NULL,
  c1t = NULL,
  m = NULL,
  plots = TRUE,
  plim = NULL,
  varlim = NULL,
  plab = NULL,
  varlab = NULL,
  vartitle = NULL,
  verbose = TRUE
)
}
\arguments{
\item{p}{The proportion of individuals to be assigned to treatment.}

\item{r12}{The proportion of outcome variance explained by covariates.}

\item{c1}{The cost of sampling one unit in the control condition.}

\item{c1t}{The cost of sampling one unit in the treated condition.}

\item{m}{Total budget, default value is the total costs of sampling 600
individuals across treatment conditions.}

\item{plots}{Logical, provide variance plots if TRUE, otherwise
not; default value is TRUE.}

\item{plim}{The plot range for p, default value is c(0, 1).}

\item{varlim}{The plot range for variance, default value is c(0, 0.05).}

\item{plab}{The plot label for \code{p},
default value is "Proportion of Units in Treatment: p".}

\item{varlab}{The plot label for variance,
default value is "Variance".}

\item{vartitle}{The title of variance plot, default value is NULL.}

\item{verbose}{Logical; print the value of \code{p} if TRUE,
otherwise not; default value is TRUE.}
}
\value{
Unconstrained or constrained optimal sample allocation (\code{p}).
    The function also returns function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of single-level experiments detecting
    equivalence of two-group means is to choose the optimal sample
    allocation that minimizes the variance of a treatment effect under
    a fixed budget,  which is approximately the optimal
    sample allocation that maximizes statistical power under a fixed budget.
    The optimal design parameter is
    the proportion of individuals to be assigned to treatment (\code{p}).
}
\examples{
# Unconstrained optimal design #---------
  myod <- od.eq.2group(r12 = 0.5, c1 = 1, c1t = 50)
  myod$out # output

}
