% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.r
\name{convert}
\alias{convert}
\alias{as.annmatrix}
\alias{as.annmatrix.default}
\alias{as.annmatrix.matrix}
\alias{as.matrix.annmatrix}
\alias{is.annmatrix}
\title{Convert annmatrix Objects to and from Other Types}
\usage{
as.annmatrix(x)

\method{as.annmatrix}{default}(x)

\method{as.annmatrix}{matrix}(x)

\method{as.matrix}{annmatrix}(x, ...)

is.annmatrix(x)
}
\arguments{
\item{x}{an R object.}

\item{...}{additional arguments to be passed to or from methods.}
}
\value{
\code{is.annmatrix} returns TRUE if object is of class 'annmatrix' and FALSE otherwise.
        \code{as.annmatrix} methods return an object of class 'annmatrix'.
        \code{as.matrix} returns a regular matrix.
}
\description{
Methods for turning R objects to class annmatrix and vice versa.
}
\details{
\code{as.annmatrix} will attempt to convert an object to annmatrix.

\code{as.matrix} will turn an \code{annmatrix} object into a regular matrix.

\code{is.annmatrix} checks if the object is an instance of \code{annmatrix}.
}
\examples{
# construct annmatrix object
x <- matrix(rnorm(20*10), 20, 10)
X <- as.annmatrix(x)

X$group  <- rep(c("case", "control"), each = 5)
X$gender <- sample(c("M", "F"), 10, replace = TRUE)
X@chr    <- sample(c("chr1", "chr2"), 20, replace = TRUE)
X@pos    <- runif(20, 0, 1000000)

is.matrix(x)
is.matrix(X)

is.annmatrix(x)
is.annmatrix(X)

as.matrix(X)

}
\author{
Karolis Koncevičius
}
