% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/websocket.R
\name{websocket}
\alias{websocket}
\title{Start a Websocket server}
\description{
A thin wrapper of the \code{httpuv} package, modified to serve animated
plots.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{app}}{A list of functions that define the application.}

\item{\code{server}}{A server handle to be used by 'stopServer'.}

\item{\code{ws}}{A WebSocket channel to handle the communication between
the R session and the browser session.}

\item{\code{in_handler}}{A function to handle instructions sent by the
browser session.}

\item{\code{port}}{An integer; the TCP port number.}

\item{\code{connected}}{TRUE or FALSE; whether a connection has been established.
One should start the WebSocket server before launching the web page that
connects to the server.}

\item{\code{started}}{TRUE or FALSE; whether a server has been started. Use
the \code{startServer} method to start a server.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-websocket-startServer}{\code{websocket$startServer()}}
\item \href{#method-websocket-stopServer}{\code{websocket$stopServer()}}
\item \href{#method-websocket-listServers}{\code{websocket$listServers()}}
\item \href{#method-websocket-stopAllServers}{\code{websocket$stopAllServers()}}
\item \href{#method-websocket-new}{\code{websocket$new()}}
\item \href{#method-websocket-clone}{\code{websocket$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocket-startServer"></a>}}
\if{latex}{\out{\hypertarget{method-websocket-startServer}{}}}
\subsection{Method \code{startServer()}}{
Start a WebSocket server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$startServer()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocket-stopServer"></a>}}
\if{latex}{\out{\hypertarget{method-websocket-stopServer}{}}}
\subsection{Method \code{stopServer()}}{
Stop a WebSocket server
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$stopServer()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocket-listServers"></a>}}
\if{latex}{\out{\hypertarget{method-websocket-listServers}{}}}
\subsection{Method \code{listServers()}}{
List all running WebSocket servers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$listServers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocket-stopAllServers"></a>}}
\if{latex}{\out{\hypertarget{method-websocket-stopAllServers}{}}}
\subsection{Method \code{stopAllServers()}}{
Stop all running WebSocket servers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$stopAllServers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocket-new"></a>}}
\if{latex}{\out{\hypertarget{method-websocket-new}{}}}
\subsection{Method \code{new()}}{
Initialise a WebSocket connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$new(in_handler, port = 9454)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{in_handler}}{A function to handle incoming message, default to
be \link[base:print]{print} which only displays the message without
any processing.}

\item{\code{port}}{An integer; the TCP port number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A 'websocket' object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocket-clone"></a>}}
\if{latex}{\out{\hypertarget{method-websocket-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocket$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
