% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{animate}
\alias{animate}
\title{A web-based graphics device for animated visualisations}
\description{
Extends the 'base' graphics functions to support frame-by-frame
animation and keyframes animation.
}
\note{
This function differs from the \code{event} function in that events
registered through \code{simple_event} do not require R at deployment to work.
}
\examples{

## ------------------------------------------------
## Method `animate$new`
## ------------------------------------------------

\donttest{
library(animate)
device <- animate$new(400, 400)  # Launch a WebSocket server
attach(device)
x <- 1:10
y <- 1:10
id <- new_id(x)   # Give each point an ID: c("ID-1", "ID-2", ..., "ID-10")
plot(x, y, id = id)

new_y <- 10:1
plot(x, new_y, id = id, transition = TRUE)  # Use transition
off()
detach(device)
}

## ------------------------------------------------
## Method `animate$chain`
## ------------------------------------------------

\donttest{
library(animate)
device <- animate$new(600, 600)  # Launch a WebSocket server
attach(device)
par(xlim = c(0, 10), ylim = c(0, 10))
plot(1:10, 1:10, id = 1:10)
points(1:10, sample(10, 10), id = 1:10,
  transition = list(
    duration = 1000,
    on = chain(function(message) {
      print(message)
      points(1:10, sample(10, 10), id = 1:10, bg = "green",
             transition = list(duration = 2000))
      })
  ))
par(xlim = NULL, ylim = NULL)  # Reset `xlim` and `ylim` in `par`
off()
detach(device)
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{connection}}{A handle for the WebSocket connection.}

\item{\code{ready_state}}{The ready state of the connection.}

\item{\code{shiny}}{TRUE or FALSE; whether the device is used with in a 'Shiny' app.}

\item{\code{session}}{A 'Shiny' session.}

\item{\code{virtual_meta}}{A list of device metadata.}

\item{\code{virtual_session}}{A virtual session simulated with 'V8'.}

\item{\code{event_handlers}}{A named list of user-defined functions for handling events.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-animate-new}{\code{animate$new()}}
\item \href{#method-animate-off}{\code{animate$off()}}
\item \href{#method-animate-send}{\code{animate$send()}}
\item \href{#method-animate-set_max_stacksize}{\code{animate$set_max_stacksize()}}
\item \href{#method-animate-svg}{\code{animate$svg()}}
\item \href{#method-animate-bars}{\code{animate$bars()}}
\item \href{#method-animate-objects}{\code{animate$objects()}}
\item \href{#method-animate-plot}{\code{animate$plot()}}
\item \href{#method-animate-points}{\code{animate$points()}}
\item \href{#method-animate-lines}{\code{animate$lines()}}
\item \href{#method-animate-abline}{\code{animate$abline()}}
\item \href{#method-animate-axis}{\code{animate$axis()}}
\item \href{#method-animate-text}{\code{animate$text()}}
\item \href{#method-animate-image}{\code{animate$image()}}
\item \href{#method-animate-event}{\code{animate$event()}}
\item \href{#method-animate-chain}{\code{animate$chain()}}
\item \href{#method-animate-simple_event}{\code{animate$simple_event()}}
\item \href{#method-animate-set}{\code{animate$set()}}
\item \href{#method-animate-par}{\code{animate$par()}}
\item \href{#method-animate-remove}{\code{animate$remove()}}
\item \href{#method-animate-clear}{\code{animate$clear()}}
\item \href{#method-animate-delete}{\code{animate$delete()}}
\item \href{#method-animate-import}{\code{animate$import()}}
\item \href{#method-animate-export}{\code{animate$export()}}
\item \href{#method-animate-record}{\code{animate$record()}}
\item \href{#method-animate-observeAnimateEvent}{\code{animate$observeAnimateEvent()}}
\item \href{#method-animate-clone}{\code{animate$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-new"></a>}}
\if{latex}{\out{\hypertarget{method-animate-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the device
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$new(width, height, id = "SVG_1", launch.browser, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{An integer; the width in pixels.}

\item{\code{height}}{An integer; the height in pixels.}

\item{\code{id}}{A character string; the id assigned to the device.}

\item{\code{launch.browser}}{A function to launch a viewer; two options are
\code{rstudioapi::viewer} and \code{utils::browseURL}. It defaults to the first
option if the user is using RStudio and to the second option otherwise.
The default applies to interactive session only.}

\item{\code{...}}{Additional arguments. Use \code{virtual = TRUE} to use the virtual
device, \code{shiny = TRUE} for shiny application; everything else will be
passed to the SVG element that hosts the visualisation.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
library(animate)
device <- animate$new(400, 400)  # Launch a WebSocket server
attach(device)
x <- 1:10
y <- 1:10
id <- new_id(x)   # Give each point an ID: c("ID-1", "ID-2", ..., "ID-10")
plot(x, y, id = id)

new_y <- 10:1
plot(x, new_y, id = id, transition = TRUE)  # Use transition
off()
detach(device)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-off"></a>}}
\if{latex}{\out{\hypertarget{method-animate-off}{}}}
\subsection{Method \code{off()}}{
Switch off the device; this function closes the WebSocket connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$off()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-send"></a>}}
\if{latex}{\out{\hypertarget{method-animate-send}{}}}
\subsection{Method \code{send()}}{
Send commands to device
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$send(message)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{message}}{The message to send to the device.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-set_max_stacksize"></a>}}
\if{latex}{\out{\hypertarget{method-animate-set_max_stacksize}{}}}
\subsection{Method \code{set_max_stacksize()}}{
Set the maximum size of the stack
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$set_max_stacksize(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{The number of commands the plot stack can hold. Use
-1 for unlimited number of commands.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-svg"></a>}}
\if{latex}{\out{\hypertarget{method-animate-svg}{}}}
\subsection{Method \code{svg()}}{
Initialise a SVG element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$svg(width = 800, height = 600, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{Width of the canvas in pixels.}

\item{\code{height}}{Height of the canvas in pixels.}

\item{\code{...}}{Additional parameters. Some commonly used parameters are \code{id}
and \code{root}. \code{id} assigns an id to the SVG element for future reference;
\code{root} specifies the DOM element to insert the SVG element into.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-bars"></a>}}
\if{latex}{\out{\hypertarget{method-animate-bars}{}}}
\subsection{Method \code{bars()}}{
Add bars to a plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$bars(x, y, w, h, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The x coordinates of the bars.}

\item{\code{y}}{The y coordinates of the bars.}

\item{\code{w}}{The width of the bars.}

\item{\code{h}}{The height of the bars.}

\item{\code{...}}{Additional graphical parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-objects"></a>}}
\if{latex}{\out{\hypertarget{method-animate-objects}{}}}
\subsection{Method \code{objects()}}{
Add HTML objects to a plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$objects(x, y, w, h, content, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The x coordinates of the objects.}

\item{\code{y}}{The y coordinates of the objects.}

\item{\code{w}}{The width of the objects.}

\item{\code{h}}{The height of the objects.}

\item{\code{content}}{The content of the objects; the HTML string.}

\item{\code{...}}{Additional graphical parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-plot"></a>}}
\if{latex}{\out{\hypertarget{method-animate-plot}{}}}
\subsection{Method \code{plot()}}{
Generic X-Y plotting
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$plot(x, y, type = "p", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The x coordinates of the data.}

\item{\code{y}}{The y coordinates of the data.}

\item{\code{type}}{Type of the plot; one of 'p' and 'l'.}

\item{\code{...}}{Additional graphical parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-points"></a>}}
\if{latex}{\out{\hypertarget{method-animate-points}{}}}
\subsection{Method \code{points()}}{
Add points to a plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$points(x, y, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The x coordinates of the points.}

\item{\code{y}}{The y coordinates of the points.}

\item{\code{...}}{Additional graphical parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Options for the "pch" parameter: "circle", "plus", "diamond", "square",
"star", "triangle", "wye", "triangle_down", "triangle_left", "triangle_right",
"diamond_alt", "diamond_square", "pentagon", "hexagon", "hexagon_alt",
"octagon", "octagon_alt", "cross".

The unit of the "cex" parameter is squared pixels, corresponding to how
much pixel space the symbol would cover. The convention comes from the
'D3' library, and the choice is (believed) to make plots visually consistent
across the different symbols.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-lines"></a>}}
\if{latex}{\out{\hypertarget{method-animate-lines}{}}}
\subsection{Method \code{lines()}}{
Add line segments / paths to a plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$lines(x, y, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The x coordinates of the line.}

\item{\code{y}}{The y coordinates of the line.}

\item{\code{...}}{Additional graphical parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-abline"></a>}}
\if{latex}{\out{\hypertarget{method-animate-abline}{}}}
\subsection{Method \code{abline()}}{
Add straight lines to a plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$abline(a, b, h, v, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{The intercept.}

\item{\code{b}}{The slope.}

\item{\code{h}}{The y-value(s) for horizontal line(s).}

\item{\code{v}}{The x-value(s) for vertical line(s).}

\item{\code{...}}{Additional graphical parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-axis"></a>}}
\if{latex}{\out{\hypertarget{method-animate-axis}{}}}
\subsection{Method \code{axis()}}{
Add an axis to a plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$axis(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The x coordinates of the text.}

\item{\code{...}}{Additional graphical parameters.}

\item{\code{y}}{The y coordinates of the text.}

\item{\code{labels}}{The text.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-text"></a>}}
\if{latex}{\out{\hypertarget{method-animate-text}{}}}
\subsection{Method \code{text()}}{
Add text to a plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$text(x, y, labels, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The x coordinates of the text.}

\item{\code{y}}{The y coordinates of the text.}

\item{\code{labels}}{The text.}

\item{\code{...}}{Additional graphical parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-image"></a>}}
\if{latex}{\out{\hypertarget{method-animate-image}{}}}
\subsection{Method \code{image()}}{
Add background image to a plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$image(href, width, height, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{href}}{The link to the image.}

\item{\code{width}}{The width of the image.}

\item{\code{height}}{Th height of the image.}

\item{\code{...}}{Additional graphical parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-event"></a>}}
\if{latex}{\out{\hypertarget{method-animate-event}{}}}
\subsection{Method \code{event()}}{
Attach an interactive event to an element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$event(selector, event_type, callback)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{selector}}{A character string; a CSS selector.}

\item{\code{event_type}}{A character string; the event type. For example, "click", "mouseover",
"mouseout". See more options at \url{https://www.w3schools.com/jsref/dom_obj_event.asp}.}

\item{\code{callback}}{A function, to be called when the event is triggered.
The function should take an argument to receive the data from the
browser end.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-chain"></a>}}
\if{latex}{\out{\hypertarget{method-animate-chain}{}}}
\subsection{Method \code{chain()}}{
Chain a transition after another.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$chain(callback)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{callback}}{A function, to be called when the event is triggered.
The function should take an argument to receive the data from the
browser end.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
library(animate)
device <- animate$new(600, 600)  # Launch a WebSocket server
attach(device)
par(xlim = c(0, 10), ylim = c(0, 10))
plot(1:10, 1:10, id = 1:10)
points(1:10, sample(10, 10), id = 1:10,
  transition = list(
    duration = 1000,
    on = chain(function(message) {
      print(message)
      points(1:10, sample(10, 10), id = 1:10, bg = "green",
             transition = list(duration = 2000))
      })
  ))
par(xlim = NULL, ylim = NULL)  # Reset `xlim` and `ylim` in `par`
off()
detach(device)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-simple_event"></a>}}
\if{latex}{\out{\hypertarget{method-animate-simple_event}{}}}
\subsection{Method \code{simple_event()}}{
Attach a captured event to an element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$simple_event(selector, event_type, method, param)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{selector}}{A character string; a CSS selector.}

\item{\code{event_type}}{A character string; the event type. For example, "click", "mouseover",
"mouseout". See more options at \url{https://www.w3schools.com/jsref/dom_obj_event.asp}.}

\item{\code{method}}{A character string; the name of a device function (e.g. "points").}

\item{\code{param}}{A named list of arguments to be called with.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-set"></a>}}
\if{latex}{\out{\hypertarget{method-animate-set}{}}}
\subsection{Method \code{set()}}{
Set the active device to a SVG element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$set(device_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{device_id}}{A character vector; ID of the device.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-par"></a>}}
\if{latex}{\out{\hypertarget{method-animate-par}{}}}
\subsection{Method \code{par()}}{
Set the graphical parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$par(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The graphical parameters}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-remove"></a>}}
\if{latex}{\out{\hypertarget{method-animate-remove}{}}}
\subsection{Method \code{remove()}}{
Remove elements from the active SVG element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$remove(id = NULL, selector = "*")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{A character vector; the ID of the elements.}

\item{\code{selector}}{A character vector; a CSS selector.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-clear"></a>}}
\if{latex}{\out{\hypertarget{method-animate-clear}{}}}
\subsection{Method \code{clear()}}{
Remove all elements from the active SVG element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-delete"></a>}}
\if{latex}{\out{\hypertarget{method-animate-delete}{}}}
\subsection{Method \code{delete()}}{
Remove a SVG element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$delete(id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{A character string; the ID of the SVG. If not provided, remove
the active SVG element.
#' @description
#' Perform a group of graphical operations to a plot
#' @param ... Any number of graphical operations.
group = function(...) {
self$send(Message("fn_group", c(...)))
},}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-import"></a>}}
\if{latex}{\out{\hypertarget{method-animate-import}{}}}
\subsection{Method \code{import()}}{
Import an animated plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$import(setting)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{setting}}{A JSON file exported from previous runs.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-export"></a>}}
\if{latex}{\out{\hypertarget{method-animate-export}{}}}
\subsection{Method \code{export()}}{
Export an animated plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$export(path = "./animate.json", handler = "browser")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A character string; the file path to export to.}

\item{\code{handler}}{'r' or 'browser'; the program to handle the export operation.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-record"></a>}}
\if{latex}{\out{\hypertarget{method-animate-record}{}}}
\subsection{Method \code{record()}}{
Record an animated plot as a MP4 video
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$record()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This function will prompt you to select a screen / window / tab to
record. Once started, the recording can be stopped by using the stop button
at the notification box, or clicking anywhere on the page near the device.
Always confirm that the screen recording notification box is gone.
The captured video will be downloaded right after the recording stops.

This uses web browsers' Media Streams API to record the screen
and return the captured frames as a video. The entire process runs locally.
The source file that provides this functionality can be found at
\code{system.file("addons/screen_record.js", package = "animate")}.

This function is disabled for 'Shiny' app and R Markdown document.

This function does not work in the RStudio viewer. Please use the
"show in new window" button to launch the page with a web browser.

See browser compatibility at: \url{https://developer.mozilla.org/en-US/docs/Web/API/MediaStream_Recording_API#browser_compatibility}

See Media Streams API reference at: \url{https://developer.mozilla.org/en-US/docs/Web/API/Media_Streams_API}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-observeAnimateEvent"></a>}}
\if{latex}{\out{\hypertarget{method-animate-observeAnimateEvent}{}}}
\subsection{Method \code{observeAnimateEvent()}}{
Event handler
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$observeAnimateEvent(input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{The input object in the \code{server} function of a 'Shiny' app.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-animate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-animate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{animate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
