% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc-utils.r
\name{romsdata}
\alias{romsdata}
\alias{roms_xy}
\alias{romsdata}
\alias{roms_xz}
\alias{romsdata}
\alias{roms_xt}
\alias{romsdata}
\alias{roms_yz}
\alias{romsdata}
\alias{roms_yt}
\alias{romsdata}
\alias{roms_zt}
\alias{romsdata}
\title{ROMS single slice 2D layer

Extract a data layer from ROMS by name and 4-D slice.}
\usage{
roms_xy(x, varname, slice = c(1L, 1L), transpose = TRUE, ...)

roms_xz(x, varname, slice = c(1L, 1L), transpose = TRUE, ...)

roms_xt(x, varname, slice = c(1L, 1L), transpose = TRUE, ...)

roms_yz(x, varname, slice = c(1L, 1L), transpose = TRUE, ...)

roms_yt(x, varname, slice = c(1L, 1L), transpose = TRUE, ...)

roms_zt(x, varname, slice = c(1L, 1L), transpose = TRUE, ...)

romsdata(x, varname, slice = c(1L, 1L), ncdf = TRUE, transpose = TRUE,
  ...)
}
\arguments{
\item{x}{ROMS file name}

\item{varname}{name of ROMS variable}

\item{slice}{index in w and t (depth and time), defaults to first encountered}

\item{transpose}{the extents (ROMS is FALSE, Access is TRUE)}

\item{...}{unused}

\item{ncdf}{default to \code{TRUE}, set to \code{FALSE} to allow raster format detection brick}
}
\value{
RasterLayer
}
\description{
\code{romsdata} always works in the first two dimensions (x-y), the more specialist functions will
work in the space indicated by their name \code{roms_xy}, \code{roms_xt} and so on.
}
\examples{
#x <- raadtools:::cpolarfiles()$fullname[1]
#plot(roms_xy(x, "u"))
#plot(roms_xz(x, "u", slice = c(392L,1L)), asp = NA)
#plot(roms_xt(x, "u", slice = c(392L,1L)), asp = NA)

#plot(roms_yz(x, "u"))
#plot(roms_yt(x, "u", slice = c(1L,1L)), asp = NA)
#plot(roms_zt(x, "u", slice = c(1L, 392L)), asp = NA)
}
