% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/andrews0.R
\name{andrews0}
\alias{andrews0}
\title{Andrews curves}
\usage{
andrews0(
  df,
  type = 1,
  clr = NULL,
  step = 100,
  ymax = 10,
  main = NULL,
  sub = NULL
)
}
\arguments{
\item{df}{data frame}

\item{type}{type of curve
\itemize{
\item \code{1}: \eqn{f(t)=x_1/\sqrt{2}+x_2\sin(t)+x_3\cos(t)+x_4\sin(2t)+x_5\cos(2t)+...}
\item \code{2}: \eqn{f(t)=x_1\sin(t)+x_2\cos(t)+x_3\sin(2t)+x_4\cos(2t)+...}
\item \code{3}: \eqn{f(t)=0.5^{p/2}x_1+0.5^{(p-1)/2} x_2(\sin(t)+\cos(t))+0.5^{(p-2)/2} x_3(\sin(t)-\cos(t))+0.5^{(p-3)/2} x_4(\sin(2t)+\cos(2t))+0.5^{(p-6)/2}x_5(\sin(2t)-\cos(2t))+...)}
with $p$ the number of variables
\item \code{4}: \eqn{f(t)=1/\sqrt{2}(x_1+x_2(\sin(t)+\cos(t))+x_3(\sin(t)-\cos(t))+x_4(\sin(2t)+\cos(2t))+x_5(\sin(2t)-\cos(2t))+...)}
}}

\item{clr}{number/name of column in the date frame for color of curves}

\item{step}{smoothness of curves}

\item{ymax}{maximum of \code{y} coordinate.}

\item{main}{main title for the plot}

\item{sub}{sub title for the plot}
}
\value{
nothing
}
\description{
Andrews curves for visualization of multidimensional data.
For differences between \code{andrews} and \code{andrews2} see the `vignette("andrews").
For colouring the curves see the details.
}
\details{
Andrews curves transform multidimensional data into curves. This package presents four types of curves

If \code{df[,clr]} is numeric then \code{hsv(1,1,v)} with the normalized values (on \verb{\[0, 1\]}) of \code{df[,clr]} is used.
Otherwise the number of unique values in \code{nuv <- unique(df[,clr])} is used in connection with \code{rainbow(nuv)}.
}
\examples{
data(iris)
andrews0(iris,clr=5,ymax=3)
andrews0(iris,type=4,clr=5,ymax=2)
}
\references{
\itemize{
\item Andrews, D. F. (1972) Plots of High-Dimensional Data. Biometrics, vol. 28, no. 1, pp. 125-136.
\item Khattree, R., Naik, D. N. (2002) Andrews Plots for Multivariate Data: Some New Suggestions and Applications. Journal of Statistical Planning and Inference, vol. 100, no. 2, pp. 411-425.
}
}
\author{
Jaroslav Myslivec \href{mailto:jaroslav.myslivec@upce.cz}{jaroslav.myslivec@upce.cz}
}
\keyword{hplot}
