% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{proxy_plot}
\alias{proxy_plot}
\alias{plot,ProxyRecord,missing-method}
\title{Plot Layer-Counted Proxy Records Uncertainties}
\usage{
\S4method{plot}{ProxyRecord,missing}(
  x,
  calendar = get_calendar(),
  iqr = TRUE,
  xlab = NULL,
  ylab = NULL,
  col = grDevices::hcl.colors(12, "YlOrRd", rev = TRUE),
  col.mean = "black",
  col.iqr = col.mean,
  lty.mean = 1,
  lty.iqr = 3,
  lwd.mean = 2,
  lwd.iqr = lwd.mean,
  ...
)
}
\arguments{
\item{x}{A \code{\linkS4class{ProxyRecord}} object.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}). If \code{NULL}, \emph{rata die} are returned.}

\item{iqr}{A \code{\link{logical}} scalar: should the mean and IQR be displayed?}

\item{xlab, ylab}{A \code{\link{character}} string giving a label for the x and y axis.}

\item{col}{A list of colors such as that generated by \code{\link[grDevices:palettes]{grDevices::hcl.colors()}}.}

\item{col.mean, col.iqr}{A specification for the line colors. Only used if
\code{iqr} is \code{TRUE}.}

\item{lty.mean, lty.iqr}{A specification for the line types. Only used if
\code{iqr} is \code{TRUE}.}

\item{lwd.mean, lwd.iqr}{A specification for the line widths. Only used if
\code{iqr} is \code{TRUE}.}

\item{...}{Further parameters to be passed to \code{\link[graphics:image]{graphics::image()}}.}
}
\value{
\code{plot()} is called it for its side-effects: it results in a graphic
being displayed. Invisibly returns \code{x}.
}
\description{
Plot Layer-Counted Proxy Records Uncertainties
}
\examples{
\donttest{
## Get NGRIP records
data("ngrip2010", package = "folio")
ngrip2010 <- subset(ngrip2010, !is.na(MCE))
ngrip2010 <- ngrip2010[nrow(ngrip2010):1, ] # Sort in chronological order

## Replicate fig. 3d from Boers et al. (2017)
## /!\ This may take a while... /!\
ngrip_record <- proxy_ensemble(
  positions = ngrip2010$depth,
  proxy_values = ngrip2010$delta,
  proxy_errors = 0.01,
  proxy_step = 0.01,
  time_values = ngrip2010$age,
  time_errors = ngrip2010$MCE,
  calendar = b2k(), # /!\
  by = 20,
  n = 30
)

plot(ngrip_record)
}
}
\seealso{
Other proxy tools: 
\code{\link{proxy_ensemble}()}
}
\author{
N. Frerebeau
}
\concept{proxy tools}
