% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/c14_calibrate.R
\docType{methods}
\name{c14_calibrate}
\alias{c14_calibrate}
\alias{c14_calibrate-method}
\alias{c14_calibrate,numeric,numeric-method}
\title{14C Calibration}
\usage{
c14_calibrate(values, errors, ...)

\S4method{c14_calibrate}{numeric,numeric}(
  values,
  errors,
  curves = "intcal20",
  names = NULL,
  positions = NULL,
  reservoir_offsets = 0,
  reservoir_errors = 0,
  from = 55000,
  to = 0,
  resolution = 1,
  normalize = TRUE,
  F14C = FALSE,
  method = c("student", "normal"),
  dfs = 100,
  drop = TRUE,
  eps = 1e-06,
  verbose = getOption("ananke.verbose")
)
}
\arguments{
\item{values}{A \code{\link{numeric}} vector giving the BP ages or F14C values to be
calibrated (conventional ages).}

\item{errors}{A \code{\link{numeric}} vector giving the errors associated to the
values to be calibrated.}

\item{...}{Currently not used.}

\item{curves}{A \code{\link{character}} vector specifying the calibration curve to be
used. Different curves can be specified per sample.}

\item{names}{A \code{\link{character}} vector specifying the names of the samples (e.g.
laboratory codes).}

\item{positions}{A \code{\link{numeric}} vector giving the position values (e.g.
depths) for each age.}

\item{reservoir_offsets}{A \code{\link{numeric}} vector giving the offset values for
any marine reservoir effect (defaults to 0; i.e. no offset).}

\item{reservoir_errors}{A \code{\link{numeric}} vector giving the offset value errors
for any marine reservoir effect (defaults to 0; i.e. no offset).}

\item{from}{length-one \code{\link{numeric}} vector specifying the earliest data to
calibrate for, in cal. BP years.}

\item{to}{A length-one \code{\link{numeric}} vector specifying the latest data to
calibrate for, in cal. BP years.}

\item{resolution}{A length-one \code{\link{numeric}} vector specifying the temporal
resolution (in years) of the calibration.}

\item{normalize}{A \code{\link{logical}} scalar: should the calibration be normalized?}

\item{F14C}{A \code{\link{logical}} scalar: should the calibration be carried out in
F14C space? If \code{TRUE}, \code{values} must be expressed as F14C.}

\item{method}{A \code{\link{character}} string specifying the distribution assumed for
the 14C ages. It must be one of "\code{student}" (the default) or "\code{normal}.
Only used if \code{F14C} is \code{FALSE}.}

\item{dfs}{A \code{\link{character}} vector giving the degrees-of-freedom values for
the student t-distribution associated with the calibration calculation.
Only used if \code{method} is "\code{student}".}

\item{drop}{A \code{\link{logical}} scalar: should years with zero probability be
discarded? If \code{TRUE} (the default), results in a narrower time range.}

\item{eps}{A length-one \code{\link{numeric}} value giving the cutoff below which
calibration values will be removed.}

\item{verbose}{A \code{\link{logical}} scalar: should extra information be reported
(e.g. warning message for dates out of calibration range)?}
}
\value{
A \code{\linkS4class{CalibratedAges}} object.
}
\description{
Calibrates radiocarbon ages.
}
\note{
Adapted from \pkg{Bchron} \code{BchronCalibrate()} by Andrew Parnell and
\pkg{rcarbon} \code{calibrate()} by Andrew Bevan and Enrico Crema.
}
\examples{
## Calibrate a single date
cal <- c14_calibrate(300, 20)
plot(cal, panel.first = graphics::grid())

## Calibrate multiple dates
cal <- c14_calibrate(
  values = c(5000, 4500),
  errors = c(45, 35),
  names = c("X", "Y")
)
plot(cal, panel.first = graphics::grid())

\donttest{
## Out of 14C range?
out <- c14_calibrate(130, 20)
plot(out)
}
}
\references{
Bronk Ramsey, C. (2008). Radiocarbon Dating: Revolutions in Understanding.
\emph{Archaeometry}, 50:249-275. \doi{10.1111/j.1475-4754.2008.00394.x}.
}
\seealso{
Other radiocarbon tools: 
\code{\link{F14C}},
\code{\link{c14_combine}()},
\code{\link{c14_curve}()},
\code{\link{c14_ensemble}()},
\code{\link{c14_plot}},
\code{\link{c14_sample}()},
\code{\link{c14_spd}()},
\code{\link{c14_uncalibrate}()},
\code{\link{rec_plot}}
}
\author{
N. Frerebeau
}
\concept{radiocarbon tools}
