% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/coerce.R
\docType{methods}
\name{as.data.frame}
\alias{as.data.frame}
\alias{as.data.frame,CalibratedAges-method}
\alias{as.data.frame,CalibratedIntervals-method}
\alias{as.data.frame,RECE-method}
\alias{as.data.frame,ProxyRecord-method}
\title{Coerce to a Data Frame}
\usage{
\S4method{as.data.frame}{CalibratedAges}(x, ..., calendar = get_calendar())

\S4method{as.data.frame}{CalibratedIntervals}(x, ..., calendar = get_calendar())

\S4method{as.data.frame}{RECE}(x, ..., calendar = get_calendar())

\S4method{as.data.frame}{ProxyRecord}(x, ..., calendar = get_calendar())
}
\arguments{
\item{x}{An object.}

\item{...}{Currently not used.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}). If \code{NULL}, \emph{rata die} are returned.}
}
\value{
A \code{\link{data.frame}} with an extra \code{time} column.
}
\description{
Coerce to a Data Frame
}
\examples{
## Calibrate multiple dates
cal <- c14_calibrate(
  values = c(5000, 4500),
  errors = c(45, 35),
  names = c("X", "Y")
)

head(as.data.frame(cal))
head(as.data.frame(cal, calendar = BP()))
head(as.data.frame(cal, calendar = NULL))
}
\seealso{
Other mutators: 
\code{\link{as.list}()},
\code{\link{labels}()},
\code{\link{mutators}},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
