% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{freqTable}
\alias{freqTable}
\title{Frequency table and Histogram}
\usage{
freqTable(Value, limit = NULL)
}
\arguments{
\item{Value}{a vector of any type}

\item{limit}{Upper limit of the bars in histogram. Default is NULL,
for which the function will automatically find the suitable limit.
This value should be in fraction (between 0 to 1)}
}
\value{
Prints a table with columns \itemize{
 \item \code{Value} Value. Each row has a unique value in this table
 \item \code{Freq} The frequency count of the Value
 \item \code{Proportion} Proportion of the Value \code{(= Freq / length(x))}
}
This table is followed by a histogram with bars for each of the unique
values present in the data.
}
\description{
\code{freqTable} prints a frequency table and histogram of a vector.
}
\details{
This function works for all type of vector type. But calling \code{freqTable}
for vector with many unique values will print a very long table. If the
limit parameter is left blank, then the limit of
histogram is adjusted automatically and is shown at the end in brackets
(eg. 50% means full bar is equal to 50% frequency).
This function is used in the \code{explainer}.
}
\examples{
freqTable(mtcars$cyl)
freqTable(mtcars$mpg, limit = 0.08)

}
