% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helpers.R
\name{rankdf}
\alias{rankdf}
\title{Ranks in a data.frame}
\usage{
rankdf(df, increasing = NULL, decreasing = NULL, ...)
}
\arguments{
\item{df}{A data frame.}

\item{increasing}{A character vector of column names of the data frame to be
ranked in increasing order.}

\item{decreasing}{A character vector of column names of the data frame to be
ranked in decreasing order.}

\item{...}{Additional arguments to be passed on to
\code{\link[base:rank]{rank()}}.}
}
\value{
A data frame with the ranks computed in the columns specified in
  arguments \code{increasing} and \code{decreasing}.
}
\description{
Ranks in a data.frame
}
\examples{
library(agricolae)
data(soil)

dec <- c("pH", "EC")
inc <- c("CaCO3", "MO", "CIC", "P", "K", "sand",
         "slime", "clay", "Ca", "Mg", "K2", "Na", "Al_H", "K_Mg", "Ca_Mg",
         "B", "Cu", "Fe", "Mn", "Zn")

soilrank <- rankdf(soil, increasing = inc, decreasing = dec)
soilrank
}
