% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amerika_colors.R
\name{amerika_palette}
\alias{amerika_palette}
\title{amerika color palette generator}
\usage{
amerika_palette("name", n, "type")
}
\arguments{
\item{name}{Name of the specific palette in quotation marks. The options are: \code{Republican}, \code{Democrat}, \code{Dem_Ind_Rep3}, \code{Dem_Ind_Rep5}, \code{Dem_Ind_Rep7}}

\item{n}{Number of colors to select from the palette. If null, then all colors in the palette are selected}

\item{type}{Specify the type of color mapping, either "continuous" or "discrete" in quotation marks. Use "continuous" to include more colors than those in the palette. See \code{examples} below for more
@importFrom graphics rgb rect par image text}
}
\value{
A vector of colors
}
\description{
amerika color palette generator
}
\examples{
# Display each palette
amerika_palette("Republican")
amerika_palette("Democrat")
amerika_palette("Dem_Ind_Rep3")
amerika_palette("Dem_Ind_Rep5")
amerika_palette("Dem_Ind_Rep7")

# Interpolating between existing colors based on the palettes using the "continuous" type
amerika_palette(50, name = "Republican", type = "continuous")
amerika_palette(50, name = "Democrat", type = "continuous")
amerika_palette(50, name = "Dem_Ind_Rep3", type = "continuous")
amerika_palette(50, name = "Dem_Ind_Rep5", type = "continuous")
amerika_palette(50, name = "Dem_Ind_Rep7", type = "continuous")
}
\references{
Karthik Ram and Hadley Wickham. 2015. wesanderson: a Wes Anderson palette generator. R package version 0.3.
}
