% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{amf_data_coverage}
\alias{amf_data_coverage}
\title{Returns a list of data coverage}
\usage{
amf_data_coverage(data_product = "BASE-BADM", data_policy = "CCBY4.0")
}
\arguments{
\item{data_product}{A scalar of character specifying the data product
Currently, only "BASE-BADM" is supported.}

\item{data_policy}{A scalar of character specifying the data policy
Currently, "CCBY4.0" and "LEGACY" are supported. The default is "CCBY4.0".}
}
\value{
AmeriFlux data coverage
\itemize{
  \item SITE_ID - Six character site identifier (CC-Sss)
  \item URL -  Site page link (url)
  \item publish_years - List of data available years (YYYY)
 }
}
\description{
AmeriFlux data coverage statistics
}
\examples{
\dontrun{
# download the variable availability
data_year <- amf_data_coverage()

# download variable availability for LEGACY policy
data_year <- amf_data_coverage(data_policy = "LEGACY")
}

}
