% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrawlFunctions-trawl.R
\name{trawl_LM}
\alias{trawl_LM}
\title{Evaluates the long memory trawl function}
\usage{
trawl_LM(x, alpha, H)
}
\arguments{
\item{x}{the argument at which the supOU/long memory trawl function will be
evaluated}

\item{alpha}{the parameter \eqn{\alpha} in the long memory trawl}

\item{H}{the parameter \eqn{H} in the long memory trawl}
}
\value{
the long memory trawl function evaluated at x
}
\description{
Evaluates the long memory trawl function
}
\details{
The trawl function is parametrised by the two parameters \eqn{H> 1}
 and \eqn{\alpha > 0} as follows: \deqn{g(x) = (1-x/\alpha)^{-H},
 \mbox{ for  }  x \le 0.} If \eqn{H \in (1,2]}, then the resulting trawl
 process has long memory, for \eqn{H>2}, it has short memory.
}
\examples{
trawl_LM(-1,0.5, 1.5)
}
