% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calculate_nlcd}
\alias{calculate_nlcd}
\title{Calculate land cover covariates}
\usage{
calculate_nlcd(
  from,
  locs,
  locs_id = "site_id",
  mode = c("exact", "terra"),
  radius = 1000,
  max_cells = 5e+07,
  geom = FALSE,
  ...
)
}
\arguments{
\item{from}{SpatRaster(1). Output of \code{process_nlcd()}.}

\item{locs}{terra::SpatVector of points geometry}

\item{locs_id}{character(1). Unique identifier of locations}

\item{mode}{character(1). One of \code{"exact"}
(using \code{\link[exactextractr:exact_extract]{exactextractr::exact_extract()}})
or \code{"terra"} (using \code{\link[terra:freq]{terra::freq()}}). Ignored if \code{locs} are points.}

\item{radius}{numeric (non-negative) giving the
radius of buffer around points.}

\item{max_cells}{integer(1). Maximum number of cells to be read at once.
Higher values may expedite processing, but will increase memory usage.
Maximum possible value is \code{2^31 - 1}. Only valid when
\code{mode = "exact"}.
See \code{\link[exactextractr:exact_extract]{exactextractr::exact_extract}} for details.}

\item{geom}{FALSE/"sf"/"terra".. Should the function return with geometry?
Default is \code{FALSE}, options with geometry are "sf" or "terra". The
coordinate reference system of the \code{sf} or \code{SpatVector} is that of \code{from.}}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object
}
\description{
Compute ratio of land cover class in circle buffers around points. Returns
a \code{data.frame} object containing \code{locs_id}, longitude, latitude,
time (year), and computed ratio for each land cover class.
}
\note{
NLCD is available in U.S. only. Users should be aware of
the spatial extent of the data. The results are different depending
on \code{mode} argument. The \code{"terra"} mode is less memory intensive
but less accurate because it counts the number of cells
intersecting with the buffer. The \code{"exact"} may be more accurate
but uses more memory as it will account for the partial overlap
with the buffer.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calculate_nlcd(
  from = nlcd, # derived from process_nlcd() example
  locs = loc,
  locs_id = "id",
  mode = "exact",
  geom = FALSE
)
}
}
\seealso{
\code{\link{process_nlcd}}
}
