% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{get_gh_code_contributors}
\alias{get_gh_code_contributors}
\title{get_gh_code_contributors}
\usage{
get_gh_code_contributors(org, repo, alphabetical = FALSE)
}
\arguments{
\item{org}{Github organisation name for repository}

\item{repo}{Repository within \code{org} for which contributors are to be
extracted}

\item{alphabetical}{If \code{TRUE}, order contributors alphabetically, otherwise
order by decreasing numbers of contributions.}
}
\value{
A \code{data.frame} of two columns of contributor (name, login)
}
\description{
Get list of all code contributors to the code of a repository
}
\examples{
\dontrun{
get_gh_code_contributors (org = "ropensci", repo = "allcontributors")
}
}
\seealso{
Other github: 
\code{\link{get_gh_contrib_issue}()},
\code{\link{get_gh_issue_people}()},
\code{\link{get_gh_issue_titles}()}
}
\concept{github}
