% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_external_format.R
\name{convert_external_format}
\alias{convert_external_format}
\title{Get standard data structure}
\usage{
convert_external_format(
  inputpath_to_excelfolder,
  exportpath_to_csvfolder,
  pat_data_file_path,
  daily_mp_dose = 60,
  weekly_mtx_dose = 20
)
}
\arguments{
\item{inputpath_to_excelfolder}{Path to folder containing input excel files (in quotes)}

\item{exportpath_to_csvfolder}{Path to folder in which to save final output csv files (in quotes)}

\item{pat_data_file_path}{Path to excel file with patient IDs and corresponding BSA (body surface area) values.
Column names - "ID", "BSA".}

\item{daily_mp_dose}{numeric value of DAILY 6-Mercaptopurine dose per \eqn{1m^{2}} (\eqn{mg/m^{2}}) as per the MT dosing protocol.
Default = \eqn{60mg/m^{2}} (as per ICiCLe-ALL-14 protocol)}

\item{weekly_mtx_dose}{numeric value of WEEKLY absolute Methotrexate dose per \eqn{1m^{2}} (\eqn{mg/m^{2}}) as per the MT dosing protocol.
Default = \eqn{20mg/m^{2}} (as per ICiCLe-ALL-14 protocol)}
}
\value{
Folder with converted csv files
}
\description{
Convert a maintenance therapy excel sheet created by user into a standard format for analysis
}
\note{
If MT excel files are missing in the input folder for any patient IDs provided in the pat_data_file ID column,
the function will show a message of missing IDs but will continue to convert the available files.
}
\examples{
# As per ICiCLe-ALL-14 protocol (Reference PMID - 35101099):
path_to_excel = paste0(system.file("extdata/external_data/", package = "allMT"), "/")
save_path = paste0(tempdir(),"/")
path_to_bsa = system.file("extdata/external_data/", "BSA.xlsx", package = "allMT")
convert_external_format(inputpath_to_excelfolder = path_to_excel,
                   exportpath_to_csvfolder = save_path,
                   pat_data_file_path = path_to_bsa,
                   daily_mp_dose = 60,
                   weekly_mtx_dose = 20)
\donttest{
# As per ICiCLe-ALL-14 protocol (Reference PMID - 35101099):
convert_external_format(inputpath_to_excelfolder = "../csv_trial/",
                   exportpath_to_csvfolder = save_path,
                   pat_data_file_path = "BSAFile.xlsx")

# As per BFM protocol (Reference PMID - 15902295):
convert_external_format(inputpath_to_excelfolder = "../csv_trial/",
                   exportpath_to_csvfolder = save_path,
                   pat_data_file_path = "BSAFile.xlsx",
                   daily_mp_dose = 50,
                   weekly_mtx_dose = 20)

# As per St Jude protocol (Reference PMID - 15902295):
convert_external_format(inputpath_to_excelfolder = "../csv_trial/",
                   exportpath_to_csvfolder = save_path,
                   pat_data_file_path = "BSAFile.xlsx",
                   daily_mp_dose = 75,
                   weekly_mtx_dose = 40)
}

}
\seealso{
\code{\link[=convert_tmc_format]{convert_tmc_format()}}
}
