% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alf_session.R
\name{alf_session}
\alias{alf_session}
\title{Get connection session to Alfresco content repository}
\usage{
alf_session(server, username, password)
}
\arguments{
\item{server}{Alfresco server URL}

\item{username}{user name}

\item{password}{password}
}
\value{
Connection session to Alfresco repository
}
\description{
Validates authentication details with Alfresco content repository, returning ticket, server details and endpoints if
successful.
}
\examples{
# try to establish a connection to the alfresco content repository
my_session <-
  tryCatch(
    alf_session("http://localhost:8080", "admin", "admin"),
    error = function(e) NULL)

if (!is.null(my_session)) {

  # output session information
  print(paste("Session: [ticket = ", my_session$ticket,
                      ", server = ", my_session$server, "]", sep=""))

  # verify that the session is valid
  if (alf_session.is_valid(my_session)) print("Session verified as valid.")

  # invalidate the session so that it can no longer be used
  alf_session.invalidate(my_session)
}
}
