% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allToAllTraverse.R
\name{allToAllTraverse}
\alias{allToAllTraverse}
\title{All-to-all traversal}
\usage{
allToAllTraverse(
  map,
  traversalType,
  radii,
  radiusTraversalType,
  weightByAttribute = NULL,
  includeBetweenness = FALSE,
  quantizationWidth = NA,
  gatesOnly = FALSE,
  nthreads = 1L,
  copyMap = TRUE,
  verbose = FALSE,
  progress = FALSE
)
}
\arguments{
\item{map}{A PointMap, Axial ShapeGraph or Segment ShapeGraph}

\item{traversalType}{The traversal type. See \link{TraversalType}}

\item{radii}{A list of radii}

\item{radiusTraversalType}{The traversal type to keep track of whether the
analysis is within the each radius limit. See \link{TraversalType}}

\item{weightByAttribute}{The attribute to weigh the analysis with}

\item{includeBetweenness}{Set to TRUE to also calculate betweenness (known as
Choice in the Space Syntax domain)}

\item{quantizationWidth}{Set this to use chunks of this width instead of
continuous values for the cost of traversal. This is equivalent to the "tulip
bins" for depthmapX's tulip analysis (1024 tulip bins = pi/1024
quantizationWidth). Only works for Segment ShapeGraphs}

\item{gatesOnly}{Optional. Only calculate results at particular gate pixels.
Only works for PointMaps}

\item{nthreads}{Optional. Use more than one threads. 1 by default, set to 0
to use all available. Only available for PointMaps.}

\item{copyMap}{Optional. Copy the internal sala map}

\item{verbose}{Optional. Show more information of the process.}

\item{progress}{Optional. Enable progress display}
}
\value{
A new map with the results included
}
\description{
Runs all-to-all traversal on a map with a graph. This is applicable to:
\itemize{
  \item{PointMaps (Visibility Graph Analysis)}
  \item{Axial ShapeGraphs (Axial analysis)}
  \item{Segment ShapeGraphs (Segment analysis)}
}
}
\examples{
# Pointmap analysis (VGA)
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  pointMap <- makeVGAPointMap(
    sfMap,
    gridSize = 0.5,
    fillX = 3.0,
    fillY = 6.0,
    maxVisibility = NA,
    boundaryGraph = FALSE,
    verbose = FALSE
  )
allToAllTraverse(pointMap,
  traversalType = TraversalType$Angular,
  radii = -1L,
  radiusTraversalType = TraversalType$None
)

# Axial analysis
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_axial_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "AxialShapeGraph")
allToAllTraverse(
  shapeGraph,
  traversalType = TraversalType$Topological,
  radii = c("n", "3"),
  includeBetweenness = TRUE
)

# Segment analysis
mifFile <- system.file(
    "extdata", "testdata", "barnsbury",
    "barnsbury_small_segment_original.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeGraph <- as(sfMap, "SegmentShapeGraph")
allToAllTraverse(
  shapeGraph,
  radii = c("n", "100"),
  radiusTraversalType = TraversalType$Metric,
  traversalType = TraversalType$Angular,
  weightByAttribute = "Segment Length",
  includeBetweenness = TRUE,
  quantizationWidth = pi / 1024L,
  verbose = FALSE,
  progress = FALSE
)
}
