% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census_vest.R
\name{alarm_census_vest}
\alias{alarm_census_vest}
\title{Download Joined VEST and Census Data}
\usage{
alarm_census_vest(state, geometry = FALSE, epsg = alarm_epsg(state))
}
\arguments{
\item{state}{A state name, abbreviation, FIPS code, or ANSI code.}

\item{geometry}{If \code{TRUE} (default is \code{FALSE}), include \code{sf} geometry from Census Bureau TIGER Lines with the data.}

\item{epsg}{A numeric EPSG code to use as the coordinate system. Default is \code{alarm_epsg(state)}.}
}
\value{
tibble with Census and election data
}
\description{
Downloads Census data joined with VEST's election data. All are re-tabulated from
precincts collected by VEST to 2020 Census geographies.
}
\examples{
alarm_census_vest("DE", geometry = FALSE)
}
