% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algo_effectiveness_poly.R
\name{algo_effectiveness_poly}
\alias{algo_effectiveness_poly}
\title{Computes the actual and predicted effectiveness of a given algorithm.}
\usage{
algo_effectiveness_poly(mod, num = 1)
}
\arguments{
\item{mod}{A fitted \code{mirt} model using the function \code{irtmodel} or \code{R} package \code{mirt}.}

\item{num}{The algorithm number}
}
\value{
A list with the following components:
\item{\code{effective}}{The \code{x,y} coodinates for the actual and predicted effectiveness curves for algorithm \code{num}. }
\item{\code{predictedEff}}{The area under the predicted effectiveness curve. }
\item{\code{actualEff}}{The area under the actual effectiveness curve. }

#'@examples
set.seed(1)
x1 <- sample(1:5, 100, replace = TRUE)
x2 <- sample(1:5, 100, replace = TRUE)
x3 <- sample(1:5, 100, replace = TRUE)
X <- cbind.data.frame(x1, x2, x3)
mod <- pirtmodel(X)
out <- algo_effectiveness_poly(mod$model, num=1)
out
}
\description{
This function computes the actual and predicted effectiveness of a given algorithm for different tolerance values.
}
