% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.GRiwrm.R
\name{reduceGRiwrm}
\alias{reduceGRiwrm}
\title{Reduce the size of a GRiwrm by selecting the subset of nodes corresponding to a downstream node}
\usage{
reduceGRiwrm(griwrm, down_node, check = FALSE)
}
\arguments{
\item{griwrm}{A \emph{GRiwrm} object (See \link{CreateGRiwrm})}

\item{down_node}{The ID of the downstream node of the reduced \emph{GRiwrm}}

\item{check}{\link{logical} Check the consistency of the reduced \emph{GRiwrm}}
}
\value{
A \emph{GRiwrm} object only containing nodes located upstream the given downstream node
}
\description{
Reduce the size of a GRiwrm by selecting the subset of nodes corresponding to a downstream node
}
\examples{
data(Severn)
nodes <- Severn$BasinsInfo
nodes$model <- "RunModel_GR4J"
str(nodes)
# Mismatch column names are renamed to stick with GRiwrm requirements
rename_columns <- list(id = "gauge_id",
                       down = "downstream_id",
                       length = "distance_downstream")
griwrm_severn <- CreateGRiwrm(nodes, rename_columns)
griwrm_severn
# Network diagram with upstream basin nodes in blue, intermediate sub-basin in green
plot(griwrm_severn)
plot(reduceGRiwrm(griwrm_severn, "54032"))

}
