
<!-- README.md is generated from README.Rmd. Please edit that file -->

# airGRiwrm: airGR based Integrated Water Resource Management Modeling <img src="man/figures/logo.png" align="right" width="20%"/>

<!-- badges: start -->

[![CRAN](https://www.r-pkg.org/badges/version-ago/airGRiwrm)](https://cran.r-project.org/package=airGRiwrm)
[![Total
downloads](https://cranlogs.r-pkg.org/badges/grand-total/airGRiwrm)](https://cran.r-project.org/package=airGRiwrm)
[![License:
AGPL-3](https://img.shields.io/badge/license-AGPL--3-orange.svg)](https://cran.r-project.org/web/licenses/AGPL-3)
[![DOI:
10.15454/3CVD1I](https://img.shields.io/badge/doi-10.15454%2F3CVD1I-purple)](https://doi.org/10.15454/3CVD1I)
[![Dev check
status](https://gitlab.irstea.fr/in-wop/airGRiwrm/badges/dev/pipeline.svg)](https://gitlab.irstea.fr/in-wop/airGRiwrm/-/pipelines)
<!-- badges: end -->

**airGRiwrm** is an extension of the **airGR** R package for managing
semi-distributive hydrological model on an anthropized catchment.

This package is developed by the [mixed research unit G-EAU,
Montpellier, France](https://g-eau.fr/index.php/en/) and the [HYDRO team
of the INRAE HYCAR research unit, Antony,
France](https://webgr.inrae.fr/eng).

## Installation

``` r
# Install stable version from CRAN
install.packages("airGRiwrm")

# Or the development version from GitHub:
# install.packages("devtools")
devtools::install_github("inrae/airGRiwrm", "dev")
```

## Get started

Visit the website dedicated to the package at
<https://inrae.github.io/airGRiwrm/> for tutorials, usage examples and
documentation.

## Acknowledgement

This package has been developped as part of the IN-WOP European project
(2019-2023) and the Talanoa-Water PRIMA project (2021-2025).

The authors would like to thank the European Commission and the French
National Research Agency (ANR) for funding in the frame of the
collaborative international consortium
[IN-WOP](http://www.waterjpi.eu/joint-calls/joint-call-2018-waterworks-2017/booklet/in-wop)
financed under the 2018 Joint call of the WaterWorks2017 ERA-NET Cofund.
This ERA-NET is an integral part of the activities developed by the
Water JPI.

<p style="display: flex; flex-wrap: wrap; justify-content: space-around; align-items: center;">
<img src="man/figures/logo_water_jpi.png" alt="Water JPI"/>
<img src="man/figures/logo_water_works_2017.png" alt="Water Works 2017"/>
<img src="man/figures/logo_european_commission.jpg" alt="European Commission"/>
<img src="man/figures/logo_2018_joint_call.png" alt="2018 Joint call"/>
</p>

Talanoa-Water is part of the PRIMA Programme supported by the European
Union. The PRIMA programme is supported under Horizon 2020 the European
Union’s Framework Programme for Research and Innovation. Grant Agreement
number: 2023

<p style="display: flex; justify-content: space-between;">
<img src="https://upload.wikimedia.org/wikipedia/commons/2/29/Horizon_2020_Logo.png" alt="Logo H2020" width="25%"/>
<img src="man/figures/logo_prima.png" alt="Logo PRIMA"  width="25%"/>
</p>
