% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_human_override.R
\name{compute_stats_subgroup}
\alias{compute_stats_subgroup}
\title{Compute Risk (Human+AI v. Human) for a Subgroup Defined by AI Recommendation}
\usage{
compute_stats_subgroup(
  Y,
  D,
  Z,
  A,
  a = 1,
  nuis_funcs,
  true.pscore = NULL,
  X = NULL,
  l01 = 1
)
}
\arguments{
\item{Y}{An observed outcome (binary: numeric vector of 0 or 1).}

\item{D}{An observed decision (binary: numeric vector of 0 or 1).}

\item{Z}{A treatment indicator (binary: numeric vector of 0 or 1).}

\item{A}{An AI recommendation (binary: numeric vector of 0 or 1).}

\item{a}{A specific AI recommendation value to create the subset (numeric: 0 or 1).}

\item{nuis_funcs}{output from \code{\link{compute_nuisance_functions}}. If NULL, the function will compute the nuisance functions using the provided data. Note that \code{V} must be provided if \code{nuis_funcs} is NULL.}

\item{true.pscore}{A vector of true propensity scores (numeric), if available. Optional.}

\item{X}{Pretreatment covariate used for subgroup analysis (vector). Must be the same length as Y, D, Z, and A if provided. Default is NULL.}

\item{l01}{Ratio of the loss between false positives and false negatives}
}
\value{
A tibble the following columns:
\itemize{
 \item \code{Z_focal}: The focal treatment indicator. `1` indicates the treatment group.
 \item \code{Z_compare}: The comparison treatment indicator. `0` indicates the control group.
 \item \code{X}: Pretreatment covariate (if provided).
 \item \code{loss_diff}: The difference in loss between human+AI and human decision
 \item \code{loss_diff_se}: The standard error of the difference in loss
 \item \code{tn_fn_diff}: The difference in true negatives and false negatives between human+AI and human decision
 \item \code{tn_fn_diff_se}: The standard error of the difference in true negatives and false negatives
 \item \code{tp_diff}: The difference in true positives between human+AI and human decision
 \item \code{tp_diff_se}: The standard error of the difference in true positives
 \item \code{tn_diff}: The difference in true negatives between human+AI and human decision
 \item \code{tn_diff_se}: The standard error of the difference in true negatives
 \item \code{fn_diff}: The difference in false negatives between human+AI and human decision
 \item \code{fn_diff_se}: The standard error of the difference in false negatives
 \item \code{fp_diff}: The difference in false positives between human+AI and human decision
 \item \code{fp_diff_se}: The standard error of the difference in false positives
 }
}
\description{
Compute the difference in risk between human+AI and human decision makers, for a subgroup \eqn{\{A_i = a\}}, using AIPW estimators.
This can be used for computing how the decision maker overrides the AI recommendation.
}
\examples{
compute_stats_subgroup(
  Y = NCAdata$Y,
  D = ifelse(NCAdata$D == 0, 0, 1),
  Z = NCAdata$Z,
  A = PSAdata$DMF,
  a = 1,
  nuis_funcs = nuis_func,
  true.pscore = rep(0.5, nrow(NCAdata)),
  X = NULL,
  l01 = 1
)

}
