% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crt.R
\name{SpilloverCRT}
\alias{SpilloverCRT}
\title{Conduct conditional randomization test}
\usage{
SpilloverCRT(D, Z, CourtEvent_HearingDate, n = 100, seed.number = 12345)
}
\arguments{
\item{D}{A numeric vector of judge's decision.}

\item{Z}{A numeric vector of treatment variable.}

\item{CourtEvent_HearingDate}{The court event hearing date.}

\item{n}{Number of permutations.}

\item{seed.number}{An integer for random number generator.}
}
\value{
A \code{list} of the observed and permuted test statistics and its p-value.
}
\description{
See S3.1 for more details.
}
\examples{
\donttest{
data(synth)
data(hearingdate_synth)
crt <- SpilloverCRT(D = synth$D, Z = synth$Z, CourtEvent_HearingDate = hearingdate_synth)
}

}
