% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_ParameterDefinitions.R
\name{get_magnitude_values}
\alias{get_magnitude_values}
\title{Magnitudes of an argument}
\usage{
get_magnitude_values(magnitude, n_elements = 9L, max = NULL, min = NULL)
}
\arguments{
\item{magnitude}{\code{double} Factor using for creating the magnitude.}

\item{n_elements}{\code{int} Number of values to return.}

\item{max}{\code{double} The maximal value.}

\item{min}{\code{double} The minimal value.}
}
\value{
Returns a numeric \code{vector} with the generated values.
The values are calculated with the following formula:
max * magnitude^i for i=1,...,n_elements.
Only values equal or greater \code{min} are returned.
}
\description{
Function calculates different magnitude for a numeric argument.
}
\seealso{
Other Parameter Dictionary: 
\code{\link{BaseModelsIndex}},
\code{\link{DataSetsIndex}},
\code{\link{TokenizerIndex}},
\code{\link{doc_formula}()},
\code{\link{get_TEClassifiers_class_names}()},
\code{\link{get_called_args}()},
\code{\link{get_depr_obj_names}()},
\code{\link{get_param_def}()},
\code{\link{get_param_dict}()},
\code{\link{get_param_doc_desc}()}
}
\concept{Parameter Dictionary}
