% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model}
\alias{model}
\title{AI/ML models}
\usage{
model(data, type = "lm", config = NULL, verbose = FALSE)
}
\arguments{
\item{data}{data object with data to be modeled, read more \link[ai]{prodata}}

\item{type}{model type, lm (Fitting Linear Models) by default; available are lm, rlm, ctree, knn, knn1}

\item{config}{additional parameters for model, read more \link[ai]{config}}

\item{verbose}{if true the messages are displayed in console, false by default}
}
\value{
model list contains model, predicted, and expected values for all generated models
}
\description{
The \code{model} function generates AI/ML models
}
\examples{
\donttest{

model_data <- data.frame(a = c(1,2,3,4,5,6),
                         b = c(1,2,3,4,5,6),
                         s = c(1,2,3,4,5,6))

config <- config(formula = "a ~ b + s")

model_data <- prodata(model_data, status_colname = "s")

model(model_data, config)
}

}
