% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res_to_poi.R
\name{res_to_poi}
\alias{res_to_poi}
\title{Convert a residue position to an alignment position}
\usage{
res_to_poi(alignment, res)
}
\arguments{
\item{alignment}{An alignment.}

\item{res}{A residue position.}
}
\value{
An integer vector of alignment positions corresponding to residue position in the reference
  sequence.
}
\description{
This function converts an residue position to a position in the frame of
the alignment.
}
\examples{
align_ATM <- read_alignment('ATM')
align_ATM[, 1:6]

# Convert the positions of the first five residues to alignment positions
res_to_poi(align_ATM, 1:5)

}
