% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xwalk_ags.R
\name{xwalk_ags}
\alias{xwalk_ags}
\title{Crosswalk Municipality or District Statistics}
\usage{
xwalk_ags(
  data,
  ags,
  time,
  xwalk,
  variables = NULL,
  strata = NULL,
  weight = NULL,
  fuzzy_time = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{A data frame or a data frame extension (e.g. a tibble).}

\item{ags}{Name of the character variable (quoted) with municipality
AGS (Gemeinden, 8 digits) or district AGS (Kreise, 5 digits).}

\item{time}{Name of the variable (quoted) identifying the year
(YYYY format). Values will be coerced to integers.}

\item{xwalk}{Name of the crosswalk. The following crosswalks are available:
\itemize{
\item \code{xd19}, \code{xd20} for district-level data
between 1990-2019/2020.
\item \code{xm19}, \code{xm20} for municipality-level
data between 1990-2019/2020.
}}

\item{variables}{Either a vector of names (quoted) for
variables to interpolate or \code{NULL} to disable interpolation and
return the data matched with the \code{xwalk}.}

\item{strata}{Vector of variable names (quoted) or \code{NULL}. See
details.}

\item{weight}{Name of the interpolation weight or \code{NULL}.
The following are available:
\itemize{
\item \code{pop}: Population weights.
\item \code{size}: Area weights.
\item \code{emp}: Weights based on the number of employees (1998 onwards).
}}

\item{fuzzy_time}{If \code{FALSE} the crosswalk and the \code{data}
are matched exactly by \code{ags} and \code{time}. If \code{TRUE}
they are matched exactly by \code{ags} and as best as possible on
\code{time}. See details below.}

\item{verbose}{If \code{TRUE} the function outputs information on
the number of matched and unmatched rows.}
}
\value{
If interpolation is requested, the crosswalked and interpolated
data are returned. If interpolation is not requested, the \code{data} matched
with the crosswalk are returned. The following variables are added:
\itemize{
\item \code{row_id} row number of \code{data} before matching.
\item \code{ags[*]} the crosswalked AGS.
\item \code{year_xw} the matched year from the crosswalk.
\item \code{[*]_conv} the interpolation weight.
\item \code{diff} the absolute difference between \code{year_xw}
and \code{time}.
}
}
\description{
This function constructs time series of counts for Germany's municipalities
(Gemeinden) and districts (Kreise).
}
\details{
This function facilitates the use of crosswalks constructed by
the BBSR for municipalities and districts in Germany (Milbert 2010).
The crosswalks map one year's set of district/municipality
identifiers to later year's identifiers and provide weights
to perform area or population weighted interpolation.

All data rows with \code{NA}s in either the \code{ags} or \code{time}
variable are excluded. The same applies to all rows with a value in
\code{ags} or \code{time} that never appears in the crosswalk.

Fuzzy matching uses the absolute difference between the year reported
in the data and a crosswalk year. If there is a tie, crosswalk years from
before the year reported in the data are preferred.

If area or population weighted interpolation is requested (i.e., when
\code{variables} are supplied), the combination of the variables set
in \code{ags}, \code{time} and \code{strata} need to uniquely
identify a row in \code{data}.

Caution: Data from \url{https://www.regionalstatistik.de/} \emph{sometimes} includes
annual values for merged units (e.g., Städteregion Aachen, 05334)) and
for their former parts (Kreis Aachen, 05354 and Stadt Aachen, 05313).
When such data is crosswalked with \code{fuzzy_time=TRUE} and
interpolated, the final counts will be off by approximately factor 2.
The reason is that the final output is the sum of the interpolated counts
for the parts and the measured count of the merged unit.
}
\examples{

data(btw_sn)

btw_sn_ags20 <- xwalk_ags(
    data = btw_sn,
    ags = "district",
    time = "year",
    xwalk = "xd20",
    variables = c("voters", "valid"),
    weight = "pop"
)

head(btw_sn_ags20)

}
\references{
Milbert, Antonia. 2010.
\href{https://www.bbsr.bund.de/BBSR/DE/veroeffentlichungen/berichte-kompakt/2010/BK062010.html}{
"Gebietsreformen–politische Entscheidungen und Folgen für die Statistik."}
BBSR-Berichte kompakt 6/2010. Bundesinsitut für Bau-, Stadt-und Raumfoschung.
}
