% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.er.R
\name{stability.er}
\alias{stability.er}
\title{Regression on Environmental Index}
\usage{
stability.er(dataf, res_var, gen_var, env_var, rep_var, plotIt = TRUE)
}
\arguments{
\item{dataf}{the name of the data frame containing the data to analyze.}

\item{res_var}{the response variable.}

\item{gen_var}{the genotypes variable.}

\item{env_var}{the environments variable.}

\item{rep_var}{the replications variable.}

\item{plotIt}{a logical value specifying if plot should be drawn; default is TRUE}
}
\value{
Returns a list of three objects:
\describe{
  \item{ANOVA}{the analysis of variance table}
  \item{scores}{the data frame object of stability analysis results:}
  \itemize{
    \item{\code{bi} regression of genotype means on environmental index}
    \item{\code{t_value} t-values for gypothesis that bi=1}
    \item{\code{p_value} p-values for gypothesis that bi=1 }
    \item{\code{s2di} individual squared deviation from regression }
    \item{\code{pf_value} p-values for gypothesis that s2di=0 }
    \item{\code{ai} Dragavtsev's coefficient of multiplicativity}
  }
  \item{Ij}{enviromental indexes}
}
}
\description{
This function calculates the Erberhart&Rassel's stability parameters and the Dragavtsev's coefficient of multiplicativity.
}
\examples{
data(exp_data)
stability.er(exp_data,"yield","gen","env","rep")
}
\references{
Eberhart, S.A. and W.A. Russell. 1966. Stability parameters for comparing varieties. Crop Sci 6: 36-40. doi:10.2135/cropsci1966.0011183X000600010011x
}
