% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_producer}
\alias{plot_producer}
\alias{plot.citfun}
\title{Draws a Graphical Representation of a Numeric Vector}
\usage{
plot_producer(
  x,
  type = c("left.continuous", "right.continuous", "curve"),
  extend = FALSE,
  add = FALSE,
  pch = 1,
  col = 1,
  lty = 1,
  lwd = 1,
  cex = 1,
  col.steps = col,
  lty.steps = 2,
  lwd.steps = 1,
  xlab = "",
  ylab = "",
  main = "",
  xmarg = 10,
  xlim = c(0, length(x) * 1.2),
  ylim = c(a, max(x)),
  a = 0,
  ...
)
}
\arguments{
\item{x}{non-negative numeric vector}

\item{type}{character; \code{'left.continuous'} (the default)
or \code{'right.continuous'} for step functions and \code{'curve'} for
a continuous step curve}

\item{extend}{logical; should the plot be extended infinitely to the right?
Defaults to \code{FALSE}}

\item{add}{logical; indicates whether to start a new plot, \code{FALSE} by default}

\item{pch, col, lty, lwd, cex, xmarg}{graphical parameters}

\item{col.steps, lty.steps, lwd.steps}{graphical parameters, used only
for \code{type} of \code{'left.continuous'} and \code{'right.continuous'} only}

\item{ylim, xlim, xlab, ylab, main, ...}{additional graphical parameters,
see \code{\link{plot.default}}}

\item{a}{single numeric value}
}
\value{
nothing interesting
}
\description{
Draws a step function that represents a numeric vector
with elements in \eqn{[a,\infty]}.
}
\details{
In \pkg{agop}, a vector \eqn{x=(x_1,\dots,x_n)} can be represented by a
step function defined for \eqn{0\le y<n} and given by:
\deqn{\pi(y)=x_{(n-\lfloor y+1\rfloor+1)}}{\pi(y)=x_{(n-floor(y+1)+1)}}
(for \code{type == 'right.continuous'})
or for \eqn{0< y\le n} \deqn{\pi(y)=x_{(n-\lfloor y\rfloor+1)}}{\pi(y)=x_{(n-floor(y)+1)}}
(for \code{type == 'left.continuous'}, the default)
or by a curve interpolating the points \eqn{(0, x_{(n)})},
\eqn{(1, x_{(n)})}, \eqn{(1, x_{(n-1)})}, \eqn{(2, x_{(n-1)})},
..., \eqn{(n, x_{(1)})}.
Here, \eqn{x_{(i)}} denotes the
\eqn{i}-th smallest value in \eqn{x}.

In bibliometrics, a step function of one of the two above-presented types
is called a citation function.

For historical reasons, this function is also available via its alias,
\code{plot.citfun} [but its usage is deprecated].
}
\examples{
john_s <- c(11,5,4,4,3,2,2,2,2,2,1,1,1,0,0,0,0)
plot_producer(john_s, main="Smith, John", col="red")
}
\concept{visualization}
