% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-aglm.R
\name{plot.AccurateGLM}
\alias{plot.AccurateGLM}
\title{Plot contribution of each variable and residuals}
\usage{
\method{plot}{AccurateGLM}(
  x,
  vars = NULL,
  verbose = TRUE,
  s = NULL,
  resid = FALSE,
  smooth_resid = TRUE,
  smooth_resid_fun = NULL,
  ask = TRUE,
  layout = c(2, 2),
  only_plot = FALSE,
  main = "",
  add_rug = FALSE,
  ...
)
}
\arguments{
\item{x}{A model object obtained from \code{aglm()} or \code{cv.aglm()}.}

\item{vars}{Used to specify variables to be plotted (\code{NULL} means all the variables).
This parameter may have one of the following classes:
\itemize{
\item \code{integer}: specifying variables by index.
\item \code{character}: specifying variables by name.
}}

\item{verbose}{Set to \code{FALSE} if textual outputs are not needed.}

\item{s}{A numeric value specifying \eqn{\lambda} at which plotting is required.
Note that plotting for multiple \eqn{\lambda}'s are not allowed and \code{s} always should be a single value.
When the model is trained with only a single \eqn{\lambda} value, just set it to \code{NULL} to plot for that value.}

\item{resid}{Used to display residuals in plots.
This parameter may have one of the following classes:
\itemize{
\item \code{logical}(single value): If \code{TRUE}, working residuals are plotted.
\item \code{character}(single value): type of residual to be plotted. See \link{residuals.AccurateGLM} for more details on types of residuals.
\item \code{numerical}(vector): residual values to be plotted.
}}

\item{smooth_resid}{Used to display smoothing lines of residuals for quantitative variables.
This parameter may have one of the following classes:
\itemize{
\item \code{logical}: If \code{TRUE}, smoothing lines are drawn.
\item \code{character}:
\itemize{
\item \code{smooth_resid="both"}: Balls and smoothing lines are drawn.
\item \code{smooth_resid="smooth_only"}: Only smoothing lines are drawn.
}
}}

\item{smooth_resid_fun}{Set if users need custom smoothing functions.}

\item{ask}{By default, \code{plot()} stops and waits inputs each time plotting for each variable is completed.
Users can set \code{ask=FALSE} to avoid this.
It is useful, for example, when using devices as \code{bmp} to create image files.}

\item{layout}{Plotting multiple variables for each page is allowed.
To achieve this, set it to a pair of integer, which indicating number of rows and columns, respectively.}

\item{only_plot}{Set to \code{TRUE} if no automatic graphical configurations are needed.}

\item{main}{Used to specify the title of plotting.}

\item{add_rug}{Set to \code{TRUE} for rug plots.}

\item{...}{Other arguments are currently not used and just discarded.}
}
\value{
No return value, called for side effects.
}
\description{
Plot contribution of each variable and residuals
}
\examples{

#################### using plot() and predict() ####################

library(MASS) # For Boston
library(aglm)

## Read data
xy <- Boston # xy is a data.frame to be processed.
colnames(xy)[ncol(xy)] <- "y" # Let medv be the objective variable, y.

## Split data into train and test
n <- nrow(xy) # Sample size.
set.seed(2018) # For reproducibility.
test.id <- sample(n, round(n/4)) # ID numbders for test data.
test <- xy[test.id,] # test is the data.frame for testing.
train <- xy[-test.id,] # train is the data.frame for training.
x <- train[-ncol(xy)]
y <- train$y
newx <- test[-ncol(xy)]
y_true <- test$y

## With the result of aglm()
model <- aglm(x, y)
lambda <- 0.1

plot(model, s=lambda, resid=TRUE, add_rug=TRUE,
     verbose=FALSE, layout=c(3, 3))

y_pred <- predict(model, newx=newx, s=lambda)
plot(y_true, y_pred)

## With the result of cv.aglm()
model <- cv.aglm(x, y)
lambda <- model@lambda.min

plot(model, s=lambda, resid=TRUE, add_rug=TRUE,
     verbose=FALSE, layout=c(3, 3))

y_pred <- predict(model, newx=newx, s=lambda)
plot(y_true, y_pred)


}
\references{
Suguru Fujita, Toyoto Tanaka, Kenji Kondo and Hirokazu Iwasawa. (2020)
\emph{AGLM: A Hybrid Modeling Method of GLM and Data Science Techniques}, \cr
\url{https://www.institutdesactuaires.com/global/gene/link.php?doc_id=16273&fg=1} \cr
\emph{Actuarial Colloquium Paris 2020}
}
\author{
\itemize{
\item Kenji Kondo,
\item Kazuhisa Takahashi and Hikari Banno (worked on L-Variable related features)
}
}
