% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{compute_moment}
\alias{compute_moment}
\alias{compute_moment.list}
\alias{compute_moment.aghq}
\alias{compute_moment.default}
\title{Compute moments}
\usage{
compute_moment(obj, ...)

\method{compute_moment}{list}(
  obj,
  ff = function(x) 1,
  gg = NULL,
  nn = NULL,
  type = c("raw", "central"),
  method = c("auto", "reuse", "correct"),
  ...
)

\method{compute_moment}{aghq}(
  obj,
  ff = function(x) 1,
  gg = NULL,
  nn = NULL,
  type = c("raw", "central"),
  method = c("auto", "reuse", "correct"),
  ...
)

\method{compute_moment}{default}(
  obj,
  ff = function(x) 1,
  gg = NULL,
  method = c("auto", "reuse", "correct"),
  ...
)
}
\arguments{
\item{obj}{Object of class \code{aghq} output by \code{aghq::aghq()}. See \code{?aghq}.}

\item{...}{Used to pass additional argument \code{ff}.}

\item{ff}{Any R function which takes in a numeric vector and returns a numeric vector. Exactly one of \code{ff} or \code{gg} must be provided. If both are provided, \code{aghq::compute_moment()} will use \code{gg},
without warning.}

\item{gg}{The output of, or an object which may be input to \code{aghq::make_moment_function()}. See documentation of that function. Exactly one of \code{ff} or \code{gg} must be provided. If both are provided, \code{aghq::compute_moment()} will use \code{gg},
without warning.}

\item{nn}{A numeric scalar. Compute the approximate moment of this order, \code{E(theta^nn|Y)}. See details.
If \code{nn} is provided, \code{compute_moment} will use it over \code{ff} or \code{gg},
without warning.}

\item{type}{Either \code{'raw'} (default) or \code{'central'}, see details.}

\item{method}{Method for computing the quadrature points used to approximate moment. One of \code{'reuse'} (default) or \code{'correct'}. See details. The default SHOULD be \code{'correct'}; it is currently
set to \code{'reuse'} to maintain compatibility of results with previous versions. This will be switched in a future major release.}
}
\value{
A numeric vector containing the moment(s) of ff with respect to the joint
distribution being approximated using AGHQ.
}
\description{
Compute the moment of any function ff using AGHQ.
}
\details{
If multiple of \code{nn}, \code{gg}, and \code{ff} are provided, then \code{compute_moment}
will use \code{nn}, \code{gg}, or \code{ff}, in that order, without warning.

There are several approximations available. The "best" one is obtained by specifying \code{gg}
and using \code{method = 'correct'}. This recomputes the mode and curvature for the
function \code{g(theta)posterior(theta)}, and takes the ratio of the AGHQ approximation
to this function to the AGHQ approximation to the marginal likelihood. This obtains the
same relative rate of convergence as the AGHQ approximation to the marginal likelihood. It
may take a little extra time, and only works for \strong{positive, scalar-valued} functions \code{g}.

\code{method = 'reuse'} re-uses the AGHQ adapted points and weights. It's faster than the
correct method, because it does not involve any new optimization, it's just a weighted sum.
No convergence theory. Seems to work ok in "practice". "Works" for arbitrary \code{g}.

Specifying \code{ff} instead of \code{gg} automatically uses \code{method = 'reuse'}. This
interface is provided for backwards compatibility mostly. However, one advantage is that
it allows for \strong{vector-valued} functions, in which case it just returns the corresponding
vector of approximate moments. Also, it only requires the adapted nodes and weights, not
the ability to evaluate the log-posterior and its derivatives, although this is unlikely
to be a practical concern.

Specifying a numeric value \code{nn} will return the moment \code{E(theta^nn|Y)}.
This automatically does some internal shifting to get the evaluations away from zero,
to avoid the inherent problem of multi-modal "posteriors" that occurs when the posterior
mode is near zero, and account for the fact that some of the new adapted quadrature points
may be negative. So, the actual return value is \code{E(theta^nn + a|Y) - a} for a cleverly-chosen
value \code{a}.

Finally, \code{type='raw'} computes raw moments \code{E(g(theta)|Y)}, where \code{type='central'}
computes central moments, \code{E(g(theta - E(g(theta)|Y))|Y)}. See examples.
}
\examples{
logfteta2d <- function(eta,y) {
  # eta is now (eta1,eta2)
  # y is now (y1,y2)
  n <- length(y)
  n1 <- ceiling(n/2)
  n2 <- floor(n/2)
  y1 <- y[1:n1]
  y2 <- y[(n1+1):(n1+n2)]
  eta1 <- eta[1]
  eta2 <- eta[2]
  sum(y1) * eta1 - (length(y1) + 1) * exp(eta1) - sum(lgamma(y1+1)) + eta1 +
    sum(y2) * eta2 - (length(y2) + 1) * exp(eta2) - sum(lgamma(y2+1)) + eta2
}
set.seed(84343124)
n1 <- 5
n2 <- 5
n <- n1+n2
y1 <- rpois(n1,5)
y2 <- rpois(n2,5)
objfunc2d <- function(x) logfteta2d(x,c(y1,y2))
funlist2d <- list(
  fn = objfunc2d,
  gr = function(x) numDeriv::grad(objfunc2d,x),
  he = function(x) numDeriv::hessian(objfunc2d,x)
)
quad <- aghq(funlist2d,7,c(0,0))

}
\concept{summaries moments}
